# Give all binaries in the package realtime capabilities:
if [ -x /sbin/setcap ]; then
  ASBINS=( "amsynth" )
  for EXE in "${ASBINS[@]}" ; do
    /sbin/setcap cap_ipc_lock,cap_sys_nice=ep "usr/bin/$EXE"
  done
fi

# Update the desktop database:
if [ -x usr/bin/update-desktop-database ]; then
  chroot . /usr/bin/update-desktop-database usr/share/applications > /dev/null 2>&1
fi

# Update hicolor theme cache:
if [ -d usr/share/icons/hicolor ]; then
  if [ -x /usr/bin/gtk-update-icon-cache ]; then
    chroot . /usr/bin/gtk-update-icon-cache -f -t usr/share/icons/hicolor 1> /dev/null 2> /dev/null
  fi
fi

# Update the mime database:
if [ -x usr/bin/update-mime-database ]; then
  chroot . /usr/bin/update-mime-database usr/share/mime >/dev/null 2>&1
fi

