# Handle the incoming configuration files:
config() {
  for infile in $1; do
    NEW="$infile"
    OLD="$(dirname $NEW)/$(basename $NEW .new)"
    # If there's no config file by that name, mv it over:
    if [ ! -r $OLD ]; then
      mv $NEW $OLD
    elif [ "$(cat $OLD | md5sum)" = "$(cat $NEW | md5sum)" ]; then
      # toss the redundant copy
      rm $NEW
    fi
    # Otherwise, we leave the .new copy for the admin to consider...
  done
}

# Take care of the logrotate script
config etc/logrotate.d/ices.new

# Only way to create and use the correct uid and gid on the target system,
# is to use chroot:
chroot . <<EOR 2>/dev/null
# Add the 'icecast' group if it doesn't exist already.
/usr/sbin/groupadd icecast 2> /dev/null

# Add the 'icecast' user if it doesn't exist already
/usr/sbin/useradd -c "Icecast" -d /usr/share/icecast \
  -g icecast -s "/bin/false" icecast 2> /dev/null

# Configure the home directory
# (Home directory will exist, if icecast package was installed previously).
mkdir -p /usr/share/icecast/modules
chown -R icecast:icecast /usr/share/icecast
chmod 750 /usr/share/icecast

# Configure the configuration directory
mkdir -p /etc/icecast
chown -R icecast:icecast /etc/icecast
chmod 750 /etc/icecast

# Configure the state directory
mkdir -p /var/state/ices
chown -R icecast:icecast /var/state/ices
chmod 755 /var/state/ices
EOR

