# Handle the incoming configuration files:
config() {
  for infile in $1; do
    NEW="$infile"
    OLD="`dirname $NEW`/`basename $NEW .new`"
    # If there's no config file by that name, mv it over:
    if [ ! -r $OLD ]; then
      mv $NEW $OLD
    elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
      # toss the redundant copy
      rm $NEW
    fi
    # Otherwise, we leave the .new copy for the admin to consider...
  done
}

config etc/sane.d/epkowa.conf.new

# Update the desktop database:
if [ -x usr/bin/update-desktop-database ]; then
  chroot . /usr/bin/update-desktop-database usr/share/applications > /dev/null 2>&1
fi

# Update hicolor theme cache:
if [ -d usr/share/icons/hicolor ]; then
  if [ -x /usr/bin/gtk-update-icon-cache ]; then
    chroot . /usr/bin/gtk-update-icon-cache -f -t usr/share/icons/hicolor 1> /dev/null 2> /dev/null
  fi
fi

# Update the mime database:
if [ -x usr/bin/update-mime-database ]; then
  chroot . /usr/bin/update-mime-database usr/share/mime >/dev/null 2>&1
fi

( cd usr/lib/sane ; rm -rf libsane-epkowa.so.1 )
( cd usr/lib/sane ; ln -sf libsane-epkowa.so.1.0.15 libsane-epkowa.so.1 )
( cd usr/lib/sane ; rm -rf libsane-epkowa.so )
( cd usr/lib/sane ; ln -sf libsane-epkowa.so.1.0.15 libsane-epkowa.so )
( cd usr/lib ; rm -rf libesmod.so.2 )
( cd usr/lib ; ln -sf libesmod.so.2.0.0 libesmod.so.2 )
( cd usr/lib/gimp/2.0/plug-ins ; rm -rf iscan )
( cd usr/lib/gimp/2.0/plug-ins ; ln -sf /usr/bin/iscan iscan )
