# Handle the incoming configuration files:
config() {
  for infile in $1; do
    NEW="$infile"
    OLD="`dirname $NEW`/`basename $NEW .new`"
    # If there's no config file by that name, mv it over:
    if [ ! -r $OLD ]; then
      mv $NEW $OLD
    elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
      # toss the redundant copy
      rm $NEW
    fi
    # Otherwise, we leave the .new copy for the admin to consider...
  done
}

# Copy an existing old configuration over to the new directory:
if [ -f etc/owncloud/sync-exclude.lst -a ! -f etc/ownCloud/sync-exclude.lst ]; then
  echo "** Copying configuration file from /etc/owncloud to /etc/ownCloud"
  echo "** NOTE: Directory '/etc/owncloud' is no longer used."
  cp -a etc/owncloud/sync-exclude.lst etc/ownCloud/
fi

config etc/ownCloud/sync-exclude.lst.new

# Update the desktop database:
if [ -x usr/bin/update-desktop-database ]; then
  chroot . /usr/bin/update-desktop-database usr/share/applications > /dev/null 2>&1
fi

# Update hicolor theme cache:
if [ -d usr/share/icons/hicolor ]; then
  if [ -x /usr/bin/gtk-update-icon-cache ]; then
    chroot . /usr/bin/gtk-update-icon-cache -f -t usr/share/icons/hicolor 1> /dev/null 2> /dev/null
  fi
fi

# Update the mime database:
if [ -x usr/bin/update-mime-database ]; then
  chroot . /usr/bin/update-mime-database usr/share/mime >/dev/null 2>&1
fi

( cd usr/lib64 ; rm -rf libowncloudsync.so )
( cd usr/lib64 ; ln -sf libowncloudsync.so.0 libowncloudsync.so )
( cd usr/lib64 ; rm -rf libocsync.so )
( cd usr/lib64 ; ln -sf libocsync.so.0 libocsync.so )
( cd usr/lib64 ; rm -rf libocsync.so.0 )
( cd usr/lib64 ; ln -sf libocsync.so.0.2.1 libocsync.so.0 )
( cd usr/lib64 ; rm -rf libowncloudsync.so.0 )
( cd usr/lib64 ; ln -sf libowncloudsync.so.1.5.4 libowncloudsync.so.0 )
