/*
 * Decompiled with CFR 0.152.
 */
package jaxp;

import java.io.PrintWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SourceValidator
implements ErrorHandler {
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String IS_SUPPORTING_LOCATION_COORDINATES = "javax.xml.stream.isSupportingLocationCoordinates";
    protected static final String DEFAULT_SCHEMA_LANGUAGE = "http://www.w3.org/2001/XMLSchema";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final String DEFAULT_VALIDATION_SOURCE = "sax";
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_MEMORY_USAGE = false;
    protected PrintWriter fOut = new PrintWriter(System.out);

    public void validate(Validator validator, Source source, String string, int n, boolean bl) {
        try {
            long l = System.currentTimeMillis();
            long l2 = Runtime.getRuntime().freeMemory();
            int n2 = 0;
            while (n2 < n) {
                validator.validate(source);
                ++n2;
            }
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            long l6 = bl ? l2 - l3 : Long.MIN_VALUE;
            this.printResults(this.fOut, string, l5, l6, n);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            if (exception2 != null) {
                exception2.printStackTrace(System.err);
            }
            exception.printStackTrace(System.err);
        }
    }

    public void validate(Validator validator, XMLInputFactory xMLInputFactory, String string, int n, boolean bl) {
        try {
            StreamSource streamSource = new StreamSource(string);
            long l = System.currentTimeMillis();
            long l2 = Runtime.getRuntime().freeMemory();
            int n2 = 0;
            while (n2 < n) {
                XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(streamSource);
                validator.validate(new StAXSource(xMLStreamReader));
                xMLStreamReader.close();
                ++n2;
            }
            long l3 = Runtime.getRuntime().freeMemory();
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            long l6 = bl ? l2 - l3 : Long.MIN_VALUE;
            this.printResults(this.fOut, string, l5, l6, n);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (Exception exception) {
            System.err.println("error: Parse error occurred - " + exception.getMessage());
            Exception exception2 = exception;
            if (exception instanceof SAXException) {
                exception2 = ((SAXException)exception).getException();
            }
            if (exception2 != null) {
                exception2.printStackTrace(System.err);
            }
            exception.printStackTrace(System.err);
        }
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print((float)l / (float)n);
        }
        printWriter.print(" ms");
        if (l2 != Long.MIN_VALUE) {
            printWriter.print(", ");
            printWriter.print(l2);
            printWriter.print(" bytes");
        }
        printWriter.println();
        printWriter.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    public static void main(String[] stringArray) {
        block80: {
            Object object;
            Object object2;
            Object object3;
            if (stringArray.length == 0) {
                SourceValidator.printUsage();
                System.exit(1);
            }
            Vector<Object> vector = null;
            Vector<Object> vector2 = null;
            String string = DEFAULT_SCHEMA_LANGUAGE;
            int n = 1;
            Object object4 = DEFAULT_VALIDATION_SOURCE;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            int n2 = 0;
            while (n2 < stringArray.length) {
                block79: {
                    object3 = stringArray[n2];
                    if (((String)object3).startsWith("-")) {
                        object2 = ((String)object3).substring(1);
                        if (((String)object2).equals("l")) {
                            if (++n2 == stringArray.length) {
                                System.err.println("error: Missing argument to -l option.");
                            } else {
                                string = stringArray[n2];
                            }
                        } else if (((String)object2).equals("x")) {
                            if (++n2 == stringArray.length) {
                                System.err.println("error: Missing argument to -x option.");
                            } else {
                                object = stringArray[n2];
                                try {
                                    int n3 = Integer.parseInt((String)object);
                                    if (n3 < 1) {
                                        System.err.println("error: Repetition must be at least 1.");
                                        break block79;
                                    }
                                    n = n3;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    System.err.println("error: invalid number (" + (String)object + ").");
                                }
                            }
                        } else if (((String)object3).equals("-a")) {
                            if (vector == null) {
                                vector = new Vector<Object>();
                            }
                            while (n2 + 1 < stringArray.length && !((String)(object3 = stringArray[n2 + 1])).startsWith("-")) {
                                vector.add(object3);
                                ++n2;
                            }
                        } else if (((String)object3).equals("-i")) {
                            if (vector2 == null) {
                                vector2 = new Vector<Object>();
                            }
                            while (n2 + 1 < stringArray.length && !((String)(object3 = stringArray[n2 + 1])).startsWith("-")) {
                                vector2.add(object3);
                                ++n2;
                            }
                        } else if (((String)object3).equals("-vs")) {
                            if (n2 + 1 < stringArray.length && !((String)(object3 = stringArray[n2 + 1])).startsWith("-")) {
                                if (((String)object3).equals(DEFAULT_VALIDATION_SOURCE) || ((String)object3).equals("dom") || ((String)object3).equals("stax") || ((String)object3).equals("stream")) {
                                    object4 = object3;
                                } else {
                                    System.err.println("error: unknown source type (" + (String)object3 + ").");
                                }
                            }
                        } else if (((String)object2).equalsIgnoreCase("f")) {
                            bl = ((String)object2).equals("f");
                        } else if (((String)object2).equalsIgnoreCase("hs")) {
                            bl2 = ((String)object2).equals("hs");
                        } else if (((String)object2).equalsIgnoreCase("va")) {
                            bl3 = ((String)object2).equals("va");
                        } else if (((String)object2).equalsIgnoreCase("ga")) {
                            bl4 = ((String)object2).equals("ga");
                        } else if (((String)object2).equalsIgnoreCase("m")) {
                            bl5 = ((String)object2).equals("m");
                        } else if (((String)object2).equals("h")) {
                            SourceValidator.printUsage();
                        } else {
                            System.err.println("error: unknown option (" + (String)object2 + ").");
                        }
                    }
                }
                ++n2;
            }
            try {
                object3 = new SourceValidator();
                object2 = SchemaFactory.newInstance(string);
                ((SchemaFactory)object2).setErrorHandler((ErrorHandler)object3);
                try {
                    ((SchemaFactory)object2).setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                try {
                    ((SchemaFactory)object2).setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                try {
                    ((SchemaFactory)object2).setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/validate-annotations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/validate-annotations)");
                }
                try {
                    ((SchemaFactory)object2).setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: SchemaFactory does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: SchemaFactory does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                if (vector != null && vector.size() > 0) {
                    int n4 = vector.size();
                    Source[] sourceArray = new StreamSource[n4];
                    int n5 = 0;
                    while (n5 < n4) {
                        sourceArray[n5] = new StreamSource((String)vector.elementAt(n5));
                        ++n5;
                    }
                    object = ((SchemaFactory)object2).newSchema(sourceArray);
                } else {
                    object = ((SchemaFactory)object2).newSchema();
                }
                Validator validator = ((Schema)object).newValidator();
                validator.setErrorHandler((ErrorHandler)object3);
                try {
                    validator.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                try {
                    validator.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl2);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                try {
                    validator.setFeature(VALIDATE_ANNOTATIONS_ID, bl3);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/validate-annotations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/validate-annotations)");
                }
                try {
                    validator.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, bl4);
                }
                catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    System.err.println("warning: Validator does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                catch (SAXNotSupportedException sAXNotSupportedException) {
                    System.err.println("warning: Validator does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                if (vector2 == null || vector2.size() <= 0) break block80;
                int n6 = vector2.size();
                if (((String)object4).equals(DEFAULT_VALIDATION_SOURCE)) {
                    XMLReader xMLReader = XMLReaderFactory.createXMLReader();
                    xMLReader.setErrorHandler((ErrorHandler)object3);
                    int n7 = 0;
                    while (n7 < n6) {
                        String string2 = (String)vector2.elementAt(n7);
                        SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(string2));
                        ((SourceValidator)object3).validate(validator, sAXSource, string2, n, bl5);
                        ++n7;
                    }
                    break block80;
                }
                if (((String)object4).equals("dom")) {
                    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                    documentBuilderFactory.setNamespaceAware(true);
                    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                    documentBuilder.setErrorHandler((ErrorHandler)object3);
                    int n8 = 0;
                    while (n8 < n6) {
                        String string3 = (String)vector2.elementAt(n8);
                        Document document = documentBuilder.parse(string3);
                        DOMSource dOMSource = new DOMSource(document);
                        dOMSource.setSystemId(string3);
                        ((SourceValidator)object3).validate(validator, dOMSource, string3, n, bl5);
                        ++n8;
                    }
                    break block80;
                }
                if (((String)object4).equals("stax")) {
                    XMLInputFactory xMLInputFactory = XMLInputFactory.newInstance();
                    try {
                        xMLInputFactory.setProperty(IS_SUPPORTING_LOCATION_COORDINATES, Boolean.TRUE);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    int n9 = 0;
                    while (n9 < n6) {
                        String string4 = (String)vector2.elementAt(n9);
                        ((SourceValidator)object3).validate(validator, xMLInputFactory, string4, n, bl5);
                        ++n9;
                    }
                    break block80;
                }
                int n10 = 0;
                while (n10 < n6) {
                    String string5 = (String)vector2.elementAt(n10);
                    StreamSource streamSource = new StreamSource(string5);
                    ((SourceValidator)object3).validate(validator, streamSource, string5, n, bl5);
                    ++n10;
                }
            }
            catch (SAXParseException sAXParseException) {
            }
            catch (Exception exception) {
                Exception exception2;
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof SAXException && (object = ((SAXException)exception).getException()) != null) {
                    exception2 = object;
                }
                exception2.printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java jaxp.SourceValidator (options) ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -l name     Select schema language by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -a uri ...  Provide a list of schema documents");
        System.err.println("  -i uri ...  Provide a list of instance documents to validate");
        System.err.println("  -vs source  Select validation source (sax|dom|stax|stream)");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -ga | -GA   Turn on/off generation of synthetic schema annotations.");
        System.err.println("              NOTE: Not supported by all schema factories and validators.");
        System.err.println("  -m  | -M    Turn on/off memory usage report");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Schema language:                 http://www.w3.org/2001/XMLSchema");
        System.err.println("  Repetition:                      1");
        System.err.println("  Validation source:               sax");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Generate synthetic annotations:  ");
        System.err.println("off");
        System.err.print("  Memory:                          ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The speed and memory results from this program should NOT be used as the");
        System.err.println("  basis of parser performance comparison! Real analytical methods should be");
        System.err.println("  used. For better results, perform multiple document validations within the");
        System.err.println("  same virtual machine to remove class loading from parse time and memory usage.");
    }
}

