/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.ParserWrapper;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Counter {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected long fElements;
    protected long fAttributes;
    protected long fCharacters;
    protected long fIgnorableWhitespace;
    protected ParserWrapper.DocumentInfo fDocumentInfo;

    public void setDocumentInfo(ParserWrapper.DocumentInfo documentInfo) {
        this.fDocumentInfo = documentInfo;
    }

    public void count(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.fElements = 0L;
                this.fAttributes = 0L;
                this.fCharacters = 0L;
                this.fIgnorableWhitespace = 0L;
                Document document = (Document)node;
                this.count(document.getDocumentElement());
                break;
            }
            case 1: {
                ++this.fElements;
                Object object = node.getAttributes();
                if (object != null) {
                    this.fAttributes += (long)object.getLength();
                }
            }
            case 5: {
                Object object = node.getFirstChild();
                while (object != null) {
                    this.count((Node)object);
                    object = object.getNextSibling();
                }
                break;
            }
            case 4: {
                this.fCharacters += (long)((Text)node).getLength();
                break;
            }
            case 3: {
                if (this.fDocumentInfo == null) break;
                Text text = (Text)node;
                int n = text.getLength();
                if (this.fDocumentInfo.isIgnorableWhitespace(text)) {
                    this.fIgnorableWhitespace += (long)n;
                    break;
                }
                this.fCharacters += (long)n;
            }
        }
    }

    public void printResults(PrintWriter printWriter, String string, long l, long l2, long l3, int n) {
        printWriter.print(string);
        printWriter.print(": ");
        if (n == 1) {
            printWriter.print(l);
        } else {
            printWriter.print(l);
            printWriter.print('/');
            printWriter.print(n);
            printWriter.print('=');
            printWriter.print(l / (long)n);
        }
        printWriter.print(';');
        printWriter.print(l2);
        printWriter.print(';');
        printWriter.print(l3);
        printWriter.print(" ms (");
        printWriter.print(this.fElements);
        printWriter.print(" elems, ");
        printWriter.print(this.fAttributes);
        printWriter.print(" attrs, ");
        printWriter.print(this.fIgnorableWhitespace);
        printWriter.print(" spaces, ");
        printWriter.print(this.fCharacters);
        printWriter.print(" chars)");
        printWriter.println();
        printWriter.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Counter.printUsage();
            System.exit(1);
        }
        var1_1 = new Counter();
        var2_2 = new PrintWriter(System.out);
        var3_3 = null;
        var4_4 = 1;
        var5_5 = true;
        var6_6 = false;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = false;
        var11_11 = false;
        var12_12 = false;
        var13_13 = true;
        var14_14 = true;
        var15_15 = 0;
        while (var15_15 < var0.length) {
            block65: {
                var16_16 = var0[var15_15];
                if (!var16_16.startsWith("-")) ** GOTO lbl-1000
                var17_17 = var16_16.substring(1);
                if (var17_17.equals("p")) {
                    if (++var15_15 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var18_31 = var0[var15_15];
                    try {
                        var3_3 = (ParserWrapper)Class.forName(var18_31).newInstance();
                    }
                    catch (Exception var19_33) {
                        var3_3 = null;
                        System.err.println("error: Unable to instantiate parser (" + var18_31 + ")");
                    }
                } else if (var17_17.equals("x")) {
                    if (++var15_15 == var0.length) {
                        System.err.println("error: Missing argument to -x option.");
                    } else {
                        var18_31 = var0[var15_15];
                        try {
                            var19_34 = Integer.parseInt(var18_31);
                            if (var19_34 < 1) {
                                System.err.println("error: Repetition must be at least 1.");
                                break block65;
                            }
                            var4_4 = var19_34;
                        }
                        catch (NumberFormatException var19_35) {
                            System.err.println("error: invalid number (" + var18_31 + ").");
                        }
                    }
                } else if (var17_17.equalsIgnoreCase("n")) {
                    var5_5 = var17_17.equals("n");
                } else if (var17_17.equalsIgnoreCase("v")) {
                    var6_6 = var17_17.equals("v");
                } else if (var17_17.equalsIgnoreCase("s")) {
                    var7_7 = var17_17.equals("s");
                } else if (var17_17.equalsIgnoreCase("f")) {
                    var8_8 = var17_17.equals("f");
                } else if (var17_17.equalsIgnoreCase("hs")) {
                    var9_9 = var17_17.equals("hs");
                } else if (var17_17.equalsIgnoreCase("va")) {
                    var10_10 = var17_17.equals("va");
                } else if (var17_17.equalsIgnoreCase("dv")) {
                    var11_11 = var17_17.equals("dv");
                } else if (var17_17.equalsIgnoreCase("xi")) {
                    var12_12 = var17_17.equals("xi");
                } else if (var17_17.equalsIgnoreCase("xb")) {
                    var13_13 = var17_17.equals("xb");
                } else if (var17_17.equalsIgnoreCase("xl")) {
                    var14_14 = var17_17.equals("xl");
                } else if (var17_17.equals("h")) {
                    Counter.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var3_3 == null) {
                        try {
                            var3_3 = (ParserWrapper)Class.forName("dom.wrappers.Xerces").newInstance();
                        }
                        catch (Exception var17_18) {
                            System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                            break block65;
                        }
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/namespaces", var5_5);
                    }
                    catch (SAXException var17_19) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var3_3.setFeature("http://xml.org/sax/features/validation", var6_6);
                    }
                    catch (SAXException var17_20) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema", var7_7);
                    }
                    catch (SAXException var17_21) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var8_8);
                    }
                    catch (SAXException var17_22) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", var9_9);
                    }
                    catch (SAXException var17_23) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validate-annotations", var10_10);
                    }
                    catch (SAXException var17_24) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/validation/dynamic", var11_11);
                    }
                    catch (SAXException var17_25) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/xinclude", var12_12);
                    }
                    catch (SAXException var17_26) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", var13_13);
                    }
                    catch (SAXException var17_27) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
                    }
                    try {
                        var3_3.setFeature("http://apache.org/xml/features/xinclude/fixup-language", var14_14);
                    }
                    catch (SAXException var17_28) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
                    }
                    try {
                        var17_29 = System.currentTimeMillis();
                        var19_36 = null;
                        var20_37 = 0;
                        while (var20_37 < var4_4) {
                            var19_36 = var3_3.parse(var16_16);
                            ++var20_37;
                        }
                        var21_38 = System.currentTimeMillis();
                        var23_39 = var21_38 - var17_29;
                        var25_40 = var3_3.getDocumentInfo();
                        var1_1.setDocumentInfo(var25_40);
                        var26_41 = System.currentTimeMillis();
                        var1_1.count((Node)var19_36);
                        var28_42 = System.currentTimeMillis();
                        var30_43 = var28_42 - var26_41;
                        var32_44 = System.currentTimeMillis();
                        var1_1.count((Node)var19_36);
                        var34_45 = System.currentTimeMillis();
                        var36_46 = var34_45 - var32_44;
                        var1_1.printResults(var2_2, var16_16, var23_39, var30_43, var36_46, var4_4);
                    }
                    catch (SAXParseException var17_30) {
                    }
                    catch (Exception var18_32) {
                        System.err.println("error: Parse error occurred - " + var18_32.getMessage());
                        var19_36 = var18_32;
                        if (var18_32 instanceof SAXException) {
                            var19_36 = ((SAXException)var18_32).getException();
                        }
                        if (var19_36 != null) {
                            var19_36.printStackTrace(System.err);
                        }
                        var18_32.printStackTrace(System.err);
                    }
                }
            }
            ++var15_15;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java dom.Counter (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     dom.wrappers.Xerces");
        System.err.println("  Repetition: 1");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:            ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Validate annotations:            ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
    }
}

