/*
 *  Copyright (C) 2006  Giuseppe Torelli - <colossus73@gmail.com>
 *						Salvatore Santagati <salvatore.santagati@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef __XARCHIVER_ISO_H__
#define __XARCHIVER_ISO_H__

#include <sys/stat.h>

#include <gtk/gtk.h>
#include "interface.h"
#include "callbacks.h"
#include "main.h"
#include "archive.h"

/* volume descriptor types */
#define ISO_VD_PRIMARY       1
#define ISO_VD_SUPPLEMENTARY 2     /* Used by Joliet */
#define ISO_VD_END           255

GtkWidget *iso_properties_window;
GtkWidget *table1;
GtkWidget *name_label;
GtkWidget *size_label;
GtkWidget *image_type_label;
GtkWidget *system_id_label;
GtkWidget *volume_id_label;
GtkWidget *application_label;
GtkWidget *publisher_label;
GtkWidget *preparer_label;
GtkWidget *volume_set_label;
GtkWidget *bibliographic_label;
GtkWidget *copyright_label;
GtkWidget *abstract_label;
GtkWidget *creation_date_label;
GtkWidget *modified_date_label;
GtkWidget *expiration_date_label;
GtkWidget *effective_date_label;
GtkWidget *filename_entry;
GtkWidget *size_entry;
GtkWidget *image_type_entry;
GtkWidget *system_id_entry;
GtkWidget *volume_id_entry;
GtkWidget *application_entry;
GtkWidget *publisher_entry;
GtkWidget *preparer_entry;
GtkWidget *volume_set_entry;
GtkWidget *bibliographic_entry;
GtkWidget *copyright_entry;
GtkWidget *abstract_entry;
GtkWidget *creation_date_entry;
GtkWidget *modified_date_entry;
GtkWidget *expiration_date_entry;
GtkWidget *effective_date_entry;

struct todo
{
  struct todo * next;
  char * name;
  int extent;
  int length;
};


#define ISODCL(from, to) (to - from + 1)

struct iso_primary_descriptor {
	char type			[ISODCL (  1,   1)]; /* 711 */
	char id				[ISODCL (  2,   6)];
	char version			[ISODCL (  7,   7)]; /* 711 */
	char unused1			[ISODCL (  8,   8)];
	char system_id			[ISODCL (  9,  40)]; /* achars */
	char volume_id			[ISODCL ( 41,  72)]; /* dchars */
	char unused2			[ISODCL ( 73,  80)];
	char volume_space_size		[ISODCL ( 81,  88)]; /* 733 */
	char escape_sequences		[ISODCL ( 89, 120)];
	char volume_set_size		[ISODCL (121, 124)]; /* 723 */
	char volume_sequence_number	[ISODCL (125, 128)]; /* 723 */
	char logical_block_size		[ISODCL (129, 132)]; /* 723 */
	char path_table_size		[ISODCL (133, 140)]; /* 733 */
	char type_l_path_table		[ISODCL (141, 144)]; /* 731 */
	char opt_type_l_path_table	[ISODCL (145, 148)]; /* 731 */
	char type_m_path_table		[ISODCL (149, 152)]; /* 732 */
	char opt_type_m_path_table	[ISODCL (153, 156)]; /* 732 */
	char root_directory_record	[ISODCL (157, 190)]; /* 9.1 */
	char volume_set_id		[ISODCL (191, 318)]; /* dchars */
	char publisher_id		[ISODCL (319, 446)]; /* achars */
	char preparer_id		[ISODCL (447, 574)]; /* achars */
	char application_id		[ISODCL (575, 702)]; /* achars */
	char copyright_file_id		[ISODCL (703, 739)]; /* 7.5 dchars */
	char abstract_file_id		[ISODCL (740, 776)]; /* 7.5 dchars */
	char bibliographic_file_id	[ISODCL (777, 813)]; /* 7.5 dchars */
	char creation_date		[ISODCL (814, 830)]; /* 8.4.26.1 */
	char modification_date		[ISODCL (831, 847)]; /* 8.4.26.1 */
	char expiration_date		[ISODCL (848, 864)]; /* 8.4.26.1 */
	char effective_date		[ISODCL (865, 881)]; /* 8.4.26.1 */
	char file_structure_version	[ISODCL (882, 882)]; /* 711 */
	char unused4			[ISODCL (883, 883)];
	char application_data		[ISODCL (884, 1395)];
	char unused5			[ISODCL (1396, 2048)];
};

struct iso_directory_record {
	unsigned char length			[ISODCL (1, 1)]; /* 711 */
	unsigned char ext_attr_length		[ISODCL (2, 2)]; /* 711 */
	unsigned char extent			[ISODCL (3, 10)]; /* 733 */
	unsigned char size			[ISODCL (11, 18)]; /* 733 */
	unsigned char date			[ISODCL (19, 25)]; /* 7 by 711 */
	unsigned char flags			[ISODCL (26, 26)];
	unsigned char file_unit_size		[ISODCL (27, 27)]; /* 711 */
	unsigned char interleave			[ISODCL (28, 28)]; /* 711 */
	unsigned char volume_sequence_number	[ISODCL (29, 32)]; /* 723 */
	unsigned char name_len		[ISODCL (33, 33)]; /* 711 */
	unsigned char name			[1];
};

/*
 * Extended Attributes record according to Yellow Book.
 */
struct iso_xa_dir_record
{
	char group_id			[ISODCL(1, 2)];
	char user_id			[ISODCL(3, 4)];
	char attributes			[ISODCL(5, 6)];
	char signature			[ISODCL(7, 8)];
	char file_number		[ISODCL(9, 9)];
	char reserved			[ISODCL(10, 14)];
};

FILE *iso_stream;
struct iso_primary_descriptor ipd;
struct stat my_stat;

int iso_733 ( unsigned char *p);
int iso_723 ( unsigned char *p);
int iso_731 ( unsigned char *p);
int DetectImage (FILE *iso);
void OpenISO ( XArchive *archive );
void parse_dir (gchar *dir_name , int extent, int len, XArchive *archive);
void dump_stat(gchar *dir_name , int extent, XArchive *archive);
gboolean xa_extract_iso_file (XArchive *archive, gchar *permission, gchar *destination_path, gchar *_filename , unsigned long long int file_size, unsigned long long file_offset );
GtkWidget *create_iso_properties_window ();
#endif /* __XARCHIVER_ISO_H__ */

