/*
 *  libghal
 *
 *  Copyright (c) 2007 Brian Tarricone <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __GHAL_DRIVE_H__
#define __GHAL_DRIVE_H__

#if !defined(GHAL_IN_GHAL_H) && !defined(GHAL_COMPILATION)
#error "Do not include ghal-drive.h directly.  Instead use <ghal/ghal.h>"
#endif

#include <libhal-storage.h>

#include <ghal/ghal-device.h>
#include <ghal/ghal-volume.h>

#define GHAL_TYPE_DRIVE     (ghal_drive_get_type())
#define GHAL_DRIVE(obj)     (G_TYPE_CHECK_INSTANCE_CAST((obj), GHAL_TYPE_DRIVE, GHalDrive))
#define GHAL_IS_DRIVE(obj)  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GHAL_TYPE_DRIVE))

G_BEGIN_DECLS

typedef struct _GHalDrive         GHalDrive;
typedef struct _GHalDriveClass    GHalDriveClass;
typedef struct _GHalDrivePrivate  GHalDrivePrivate;

struct _GHalDrive
{
    GHalDevice parent;
    
    /*< private >*/
    GHalDrivePrivate *priv;
};

struct _GHalDriveClass
{
    GHalDeviceClass parent;
    
    /*< signals >*/
    void (*volume_added)(GHalDrive *drive,
                         GHalVolume *volume);
    void (*volume_removed)(GHalDrive *drive,
                           GHalVolume *volume);
};

GType ghal_drive_get_type() G_GNUC_CONST;

gboolean ghal_drive_is_hotpluggable(GHalDrive *drive);
gboolean ghal_drive_uses_removable_media(GHalDrive *drive);
gboolean ghal_drive_requires_eject(GHalDrive *drive);

LibHalDriveType ghal_drive_get_drive_type(GHalDrive *drive);
LibHalDriveBus ghal_drive_get_bus(GHalDrive *drive);
LibHalDriveCdromCaps ghal_drive_get_cdrom_caps(GHalDrive *drive);

const gchar *ghal_drive_get_vendor(GHalDrive *drive);
const gchar *ghal_drive_get_model(GHalDrive *drive);
const gchar *ghal_drive_get_serial(GHalDrive *drive);
const gchar *ghal_drive_get_firmware_version(GHalDrive *drive);

GList *ghal_drive_list_volumes(GHalDrive *drive);

gchar *ghal_drive_get_display_name(GHalDrive *drive);
GList *ghal_drive_get_icon_list(GHalDrive *drive);

G_END_DECLS

#endif  /* __GHAL_DRIVE_H__ */
