/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__XFPRINT_PROPERTIESDLG_H__
#define	__XFPRINT_PROPERTIESDLG_H__

#include <gtk/gtk.h>
#include <xfprinter.h>

#ifdef	__cplusplus
extern "C" {
#endif	/* !__cplusplus */

#define PROPERTIES_DLG(obj)						\
	G_TYPE_CHECK_INSTANCE_CAST(obj, properties_dlg_get_type(),PropertiesDlg)
#define PROPERTIES_DLG_CLASS(klass)					\
	G_TYPE_CHECK_CLASS_CAST(klass, properties_dlg_get_type(), PropertiesDlg)
#define PROPERTIES_IS_DLG(obj)						\
	G_TYPE_CHECK_INSTANCE_TYPE(obj, properties_dlg_get_type())

typedef struct _PropertiesDlg		PropertiesDlg;
typedef struct _PropertiesDlgClass	PropertiesDlgClass;

struct _PropertiesDlg
{
	GtkDialog	dialog;

	GtkWidget	*alias;
	GtkWidget	*name;

	GtkWidget	*postscript;
	GtkWidget	*lineprinter;
	GtkWidget	*image;

	XfPrinter	*pr;
};

struct _PropertiesDlgClass
{
	GtkDialogClass	parent_class;
};

extern GtkType		properties_dlg_get_type(void);
extern GtkWidget	*properties_dlg_new(void);
extern void		properties_dlg_popup(PropertiesDlg *, const gchar *,
					    const XfPrinter *);
extern const XfPrinter	*properties_dlg_run(PropertiesDlg *);
extern void		properties_dlg_hide(PropertiesDlg *);

#ifdef	__cplusplus
}
#endif	/* !__cplusplus */

#endif	/* !__XFPRINT_PROPERTIESDLG_H__ */
