/*
 * Program name:  equake
 * Version:	  1.03.7
 * Source file:	  equake_func.h  
 * Description:	  Equake pulls data about earthquakes and displays it in interesting ways
 *
 * Copyright (C) 2012-2015 Jeroen van Aart
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


static int button_press_callback
(
  GtkWidget *event_box,
  GdkEventButton *event,
  gpointer data
);

void equake_setprefs
(
  struct Equake_Data *equakedata
);

void equake_getprefs
(
  struct Equake_Data *equakedata
);

void equake_saveprefs
(
  struct Equake_Data *equakedata,
  FILE *fp
);

/*static void equake_applet_change_background
(
  XfcePanelPlugin *applet,
  XfcePanelPluginBackgroundType type,
  GdkColor  *colour,
  GdkPixmap *pixmap
);*/

static void equake_applet_fill
(
  XfcePanelPlugin *applet
);

void setdefaults
(
  struct Equake_Data *equakedata
);

/* process the arguments given at program startup, if any */
void process_arguments
(
  int arg,
  char **argv,
  struct Equake_Data *equakedata
);

int processdata_daily
(
  struct Equake_Data *equakedata
);

int processdata_weekly
(
  struct Equake_Data *equakedata
);

int render_equake_label
(
  struct Equake_Data *equakedata
);

static void set_label_tooltip_text
(
  GtkLabel *label,
  char *lbltxt,
  char *tooltiptxt
);

int processdata
(
  struct Equake_Data *equakedata,
  int period
);

void set_signature_file
(
  struct Equake_Data *equakedata
);

void alert_heavy_quake
(
  struct Equake_Data *equakedata,
  int pos
);

void set_magnitude_icon
(
  struct Equake_Data *equakedata,
  int pos
);

int convert_localtime
(
  struct Equake_Format *equakeformat
);

long long diff_tm
(
  struct tm *a, 
  struct tm *b
);

int eventloop
(
  struct Equake_Data *equakedata
);

/* print error message and exit */
void error
(
  char *msg,
  struct Equake_Data *equakedata
);

/* In case of partial send make sure everything is sent or give an error */
int sendall
(
  int socket, 
  char *buf, 
  int *len
);

int receiveall
(
  int socket,
  char *buf,
  int len,
  int period
);

/*
 * pull earthquake data from website
 * the data is in CSV format (Comma separated ASCII text)
 */
int getquakedata
(
  struct Equake_Data *equakedata,
  int period
);

int startequake
(
  XfcePanelPlugin *applet,
  GtkWidget *label,
  GtkWidget *logo,
  struct Equake_Data *equakedata
);

/* menu functions */
static void do_update
(
  XfcePanelPlugin *applet, 
  struct Equake_Data *equakedata
);

static void load_details
(
  XfcePanelPlugin *applet,
  struct Equake_Data *equakedata
);

static void load_map
(
  XfcePanelPlugin *applet,
  struct Equake_Data *equakedata
);

static void load_didyoufeelit
(
  XfcePanelPlugin *applet,
  struct Equake_Data *equakedata
);

static void display_properties_dialog 
(
  XfcePanelPlugin *applet,
  struct Equake_Data *equakedata
);

static void set_properties_from_dialog
(
  int polltime,
  int willalert,
  int alertheavy,
  int sigfilemag,
  int monitormag,
  struct Equake_Data *equakedata
);

static void display_about_dialog
(
  XfcePanelPlugin *applet,
  struct Equake_Data *equakedata
);

static void display_dialog
(
  char *t
);

static void display_url
(
  char *url
);

static void display_nonmodaldialog
(
  GtkWidget *dialog,
  char *t
);

static void display_lastweek
(
  XfcePanelPlugin *applet,
  struct Equake_Data *equakedata
);

static void display_lastday
(
  XfcePanelPlugin *applet,
  struct Equake_Data *equakedata
);

static void display_lasthour
(
  XfcePanelPlugin *applet,
  struct Equake_Data *equakedata
);

static void fill_text_period
(
  struct Equake_Data *equakedata,
  char *running,
  char *periodtext,
  int period
);

static void display_period_window
(
  char *text,
  int period
);

static void display_lastperiod
(
  struct Equake_Data *equakedata,
  int period
);

static void equake_orientation_changed
(
  XfcePanelPlugin *applet,
  GtkOrientation orientation,
  struct Equake_Data *equakedata
);

static void equake_size_changed
(
  XfcePanelPlugin *applet,
  int size,
  struct Equake_Data *equakedata
);
