/***************************************************************************

    Disk Based Hash library DBH

copyright Edscott Wilson Garcia 2002-2003
published under LGPL Public license
You should have received a license copy along with this file.

*************************************************************************


- bigendian machines should have -DTURN for binary file compatibility.
  if this is not needed, increased speed comes from *not* using -DTURN
- large file support is WIP, FILE_POINTER should be set to 8


For compilers:


-DI16_32    for 16 bit integers and 32 bit FILE_POINTERS  
-DI32_32    for 32 bit integers and 32 bit FILE_POINTERS  
-DI64_32    for 64 bit integers and 32 bit FILE_POINTERS  

FIXME:
-DI32_64    for 32 bit integers and 64 bit FILE_POINTERS 
-DI64       for 64 bit integers and 64 bit FILE_POINTERS 

****************************************************************************/

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#ifdef HAVE_MACHINE_LIMITS_H
#include <machine/limits.h>
#else 
#include <limits.h>
#endif

#include "dbh.h"

#ifndef BCC32

/* FIXME: enable Large_file support */
#ifdef _FILE_OFFSET_BITS
#if _FILE_OFFSET_BITS>32
#warning "64 bit fileoffsets are currently disabled"
#endif
#endif

#endif

/* horrores: */
#define STOP   {fprintf(stderr,"\n%c%c\n",7,7); exit(1);}
#define ABORT1 {fprintf(stderr,"\nDBH_open() error: %s can only use dbh files %s",DBH_FILE_VERSION,DBH_FILE_VERSION);STOP}
#define ABORT2 {fprintf(stderr,"\nCannot generate file in memory at regenMEM%c%c\n",7,7);exit(1);}
#define ABORT3 {fprintf(stderr,"\nName must not exceed 255 bytes"); STOP}
#define ABORT5 {fprintf(stderr,"\nMust define function operate(place*) before doing a sweep\n"); STOP}
#define ABORT7 {fprintf(stderr,"\nProblems in randomfilename(),%c%c\n",7,7);exit(1);}
#define WARNING1 {fprintf(stderr,"malloc returns NULL. DBH_tempdir not set!\n");}
#define WARNING3 {fprintf(stderr,"\nCannot open DBH file for writing. \n Opened as readonly. Check permisions or use DBH_openR() to not see this warning. \n");}
#define WARNING4 {fprintf(stderr,"\nDBH_size has been called automatically, changing to %d bytes. Verify that data was not lost in the last register.\n",node->head_info->record_length);}
#define WARNING6 {fprintf(stderr,"\nThis DBH file uses a register size of %d. If you want a smaller size, call DBH_size() before creating the file with DBH_create()\n",node->head_info->record_length);}

#ifdef I16_32
#define WARNING7 {fprintf(stderr,"\nThis DBH file is full. The LONG_MAX value is %ld.\n ",LONG_MAX);}
#endif

#ifdef I32_32
#define WARNING7 {fprintf(stderr,"\nThis DBH file is full. The INT_MAX value is %d.\n ",INT_MAX);}
#endif

#ifdef I32_64
#define WARNING7 {fprintf(stderr,"\nThis DBH file is full. The LONG_MAX value is %ld.\n ",LONG_MAX);}
#endif


#ifdef I64_32
#define WARNING7 {fprintf(stderr,"\nThis DBH file is full. The SHRT_MAX value is %d.\n ",SHRT_MAX);}
#endif

#ifdef I64_64
#define WARNING7 {fprintf(stderr,"\nThis DBH file is full. The INT_MAX value is %d.\n ",INT_MAX);}
#endif

#ifndef WARNING7
#define WARNING7 {fprintf(stderr,"\nThis DBH file is full. The LONG_MAX value is %ld.\n ",LONG_MAX);}
#endif

#define WARNING8 {fprintf(stderr,"\nNo DBH open.\n ");}

#define ERASED (node->flag&0x01)
#define TOGGLE_ERASE (node->flag ^= 0x01)
#define SET_UNERASED (node->flag &= (0xff ^ 0x01))
#define SET_ERASED (node->flag |= 0x01)
#define EZIP_NUMERO_MAXIMO 16777215 

/* static: */
#include "dbh_s.c"

/* global:  */
#include "dbh_v.c"
 

