#ifndef __LS_ICONBOX_H__
#define __LS_ICONBOX_H__

#include <glib.h>
#include <glib-object.h>

#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>

#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>

typedef enum
{
    LS_ICONBOX_TOP = 1 << 0,
    LS_ICONBOX_BOTTOM = 1 << 1,
    LS_ICONBOX_LEFT = 1 << 2,
    LS_ICONBOX_RIGHT = 1 << 3,
    LS_ICONBOX_HORIZONTAL = 1 << 4,
    LS_ICONBOX_VERTICAL = 1 << 5
} LSIconBoxPositon;

typedef enum
{
    LS_TINY = 0,
    LS_SMALL,
    LS_MEDIUM,
    LS_LARGE,
    LS_SIZES
} LSSize;

static const gint lsSize[] = { 24, 30, 45, 60 };
static const gint lsIconSize[] = { 24, 30, 45, 60 };
static const gint lsBorderWidth = 4;

#define LS_TYPE_ICONBOX 		(ls_iconbox_get_type())
#define LS_ICONBOX(obj)        		(G_TYPE_CHECK_INSTANCE_CAST ((obj), LS_TYPE_ICONBOX, LSIconBox))
#define LS_ICONBOX_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), LS_TYPE_ICONBOX, LSIconBoxClass))
#define LS_IS_ICONBOX(obj)     		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), LS_TYPE_ICONBOX))
#define LS_IS_ICONBOX_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), LS_TYPE_ICONBOX))

typedef struct _LSIconBoxClass LSIconBoxClass;
typedef struct _LSIconBoxPrivate LSIconBoxPrivate;
typedef struct _LSIconBoxConfig LSIconBoxConfig;
typedef struct _LSIconBox LSIconBox;

#include <ls_iconboxwin.h>
#include <ls_icon.h>

struct _LSIconBox
{
    GtkEventBox container;	/* parent instance                      */

    LSIconBoxPrivate *priv;
};

struct _LSIconBoxClass
{
    GtkEventBoxClass parent_class;	/* parent instance                      */

    /* GtkWidget *(*create_new_icon) (NetkWindow *pWin);
     */
};

struct _LSIconBoxConfig
{
    glong size;
};

GType ls_iconbox_get_type ();
void ls_iconbox_add_icon (LSIconBox * plsib, LSIcon * plsi);
void ls_iconbox_remove_icon (LSIconBox * plsib, LSIcon * plsi);
void ls_iconbox_dump_windows (LSIconBox * plsi);
NetkScreen *ls_iconbox_get_screen (LSIconBox * plsib);
LSIconBox *ls_iconbox_new (NetkScreen * pScreen, glong lOrientation);
void ls_iconbox_set_orientation (LSIconBox * plsib, glong lOrientation);
void ls_iconbox_set_size (LSIconBox * plsib, glong lSize);
GList *ls_iconbox_get_children (LSIconBox * plsib);
void ls_iconbox_set_show_icon (LSIconBox * plsib, gint nMin, gint nMax,
			       gint nSkip, gint nOWSMin, gint nOWSMax,
			       gint nOWSSkip);
void ls_iconbox_set_use_color (LSIconBox * plsib, gint nUseC);
void ls_iconbox_set_hide_on_empty (LSIconBox * plsi, gboolean bHide);
#endif /* ifndef __LS_ICONBOX_H__              */
