#include <gnome.h>

#include "support.h"
#include "main.h"
#include "conf.h"
#include "log.h"

G_LOCK_DEFINE_STATIC(log_mutex);
static FILE *logfile = NULL;
static gboolean retflag = TRUE;
static log_t logtype  = LOG_RX;

static gchar *lognames[] = {
	"RX",
	"TX"
};

/* ---------------------------------------------------------------------- */

void log_to_file(log_t type, const gchar *s)
{
	G_LOCK(log_mutex);

	if (!logfile) {
		G_UNLOCK(log_mutex);
		return;
	}

	if (retflag)
		fprintf(logfile, "%s: ", lognames[type]);
	else if (logtype != type)
		fprintf(logfile, "\n%s: ", lognames[type]);

	if (fputs(s, logfile) == EOF || fflush(logfile) == EOF) {
		errmsg("Error writing to log file: %m");
		fclose(logfile);
		logfile = NULL;
	}

	if (s[strlen(s) - 1] == '\n')
		retflag = TRUE;
	else
		retflag = FALSE;

	logtype = type;

	G_UNLOCK(log_mutex);
}

static void log_to_file_start(void)
{
	time_t t;
	gchar *str;

	time(&t);
	str = ctime(&t);
	str[strlen(str) - 1] = 0;
	fprintf(logfile, "--- Logging started at %s ---\n", str);
}

static void log_to_file_stop(void)
{
	time_t t;
	gchar *str;

	time(&t);
	str = ctime(&t);
	str[strlen(str) - 1] = 0;
	fprintf(logfile, "--- Logging stopped at %s ---\n", str);
}

static gchar *mklogfilename(void)
{
	gchar *filename, *logfile, *home;

	logfile = conf_get_logfile();

	if (logfile[0] == '~' && logfile[1] == '/') {
		if ((home = getenv("HOME")) == NULL)
			home = "";
		filename = g_strdup_printf("%s%s", home, logfile + 1);
	} else
		filename = g_strdup(logfile);

	return filename;
}

gboolean log_to_file_activate(gboolean start)
{
	gchar *logfilename;
	gboolean ret = TRUE;

	G_LOCK(log_mutex);
	if (start) {
		if (!logfile) {
			logfilename = mklogfilename();
			if ((logfile = fopen(logfilename, "a")) == NULL)
				ret = FALSE;
			else
				log_to_file_start();
			g_free(logfilename);
		}
	} else {
		if (logfile) {
			log_to_file_stop();
			fclose(logfile);
			logfile = NULL;
		}
	}
	G_UNLOCK(log_mutex);

	return ret;
}

/* ---------------------------------------------------------------------- */

