/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2003 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gtkutils.c - gtk utilities taken from sylpheed
 */

#include <gtk/gtk.h>
#include "gtkutils.h"

static void
gtkut_widget_draw_cb (GtkWidget * widget, GdkRectangle * area,
		      gboolean * flag)
{
  *flag = TRUE;
  gtk_signal_disconnect_by_data (GTK_OBJECT (widget), flag);
}

void
gtkut_widget_wait_for_draw (GtkWidget * widget)
{
  gboolean flag = FALSE;

  if (!GTK_WIDGET_VISIBLE (widget))
    return;

  gtk_signal_connect (GTK_OBJECT (widget), "draw",
		      GTK_SIGNAL_FUNC (gtkut_widget_draw_cb), &flag);
  while (!flag)
    gtk_main_iteration ();
}
