# xlog.spec
#
# Copyright (c) 2002-2003 Joop Stakenborg pa4tu@amsat.org
#
%define name xlog
%define version 0.8
%define release 1

# required items
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Application/Databases
Prefix: /usr
BuildRoot: /var/tmp/%{name}-%{version}
Summary: Logging program for Hamradio Operators
Vendor: Joop Stakenborg <pa4tu@amsat.org>
URL: http://people.debian.org/~pa3aba/xlog.html
Packager: Joop Stakenborg <pa4tu@amsat.org>
Source: %{name}-%{version}.tar.gz

%description
xlog is a logging program for amateur radio operators. xlog focuses on hams
who operate shortwave on a daily basis. The log is stored into a text file.
QSO's are presented in a list. Items in the list can be added, deleted or
updated. For each contact, dxcc information is displayed and bearings and
distance is calculated, both short and long path.

%prep
%setup -q

%build
export RPM_OPT_FLAGS="-O2 -march=i386"
export CFLAGS="-O2"
%configure --enable-hamlib
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc ChangeLog
/usr/bin/xlog
/usr/share/locale/nl/LC_MESSAGES/xlog.mo
/usr/share/locale/fr/LC_MESSAGES/xlog.mo
/usr/share/locale/da/LC_MESSAGES/xlog.mo
/usr/share/locale/es/LC_MESSAGES/xlog.mo
/usr/share/xlog/pixmaps/add.xpm
/usr/share/xlog/pixmaps/cancel.xpm
/usr/share/xlog/pixmaps/del.xpm
/usr/share/xlog/pixmaps/mini-clock.xpm
/usr/share/xlog/pixmaps/mini-trx.xpm
/usr/share/xlog/pixmaps/mini-xlog.xpm
/usr/share/xlog/pixmaps/ok.xpm
/usr/share/xlog/pixmaps/update.xpm
/usr/share/xlog/pixmaps/s.xpm
/usr/share/xlog/pixmaps/s0.xpm
/usr/share/xlog/pixmaps/s1.xpm
/usr/share/xlog/pixmaps/s2.xpm
/usr/share/xlog/pixmaps/s3.xpm
/usr/share/xlog/pixmaps/s4.xpm
/usr/share/xlog/pixmaps/s5.xpm
/usr/share/xlog/pixmaps/s6.xpm
/usr/share/xlog/pixmaps/s7.xpm
/usr/share/xlog/pixmaps/s8.xpm
/usr/share/xlog/pixmaps/s9.xpm
/usr/share/xlog/pixmaps/xlog.png
/usr/share/xlog/pixmaps/xlog.xpm
/usr/share/xlog/dxcc/cty.dat
/usr/share/xlog/dxcc/xlog.dat
/usr/share/xlog/remote/fromxlog.c
/usr/share/xlog/remote/Makefile
/usr/share/xlog/remote/README
/usr/share/xlog/remote/sendtoxlog.c
/usr/share/xlog/themes/xlogrc
/usr/share/man/man1/xlog.1.gz
/usr/share/xlog/README
/usr/share/xlog/FAQ
/usr/share/xlog/THANKS
/usr/share/xlog/TODO
/usr/share/xlog/AUTHORS

%changelog
* Sat Feb 09 2002 Joop Stakenborg
- Initial spec file
