#include "common.h"
#include "dragdrop.h"
#include "gnomeicu.h"
#include "gtkfunc.h"
#include "icons.h"
#include "listwindow.h"
#include "personal_info.h"
#include "util.h"
#include "v7send.h"

#include <gtk/gtk.h>

#include <string.h>

static void remove_contact_list_candidate( GtkWidget *widget, gpointer data );
static void info_list_candidate( GtkWidget *widget, gpointer data );
static void label_drag_data_received( GtkWidget *widget,
				      GdkDragContext *context,
				      gint x, gint y, GtkSelectionData *data,
				      guint info, guint time);

GtkWidget* list_window_new( const gchar *title,
			    const gchar *label_text,
			    const gchar *button_name,
			    const gchar *button_pixmap,
			    GCallback button_clicked,
			    IsInListFunc is_in_list)
{
	GtkWidget *dialog;
	GtkWidget *dialog_vbox;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *label;
	GtkWidget *image;
	GtkWidget *scrolledwindow1;
	GtkWidget *clist1;
	GtkWidget *hbuttonbox3;
	GtkWidget *remove_button;
	GtkWidget *info_button;
	GtkWidget *custom_button;

	char *buf[2];
	char *luin, *lnick;

	char *titles[2];

	GSList *contact;

	dialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (dialog), title);
	gtk_window_set_default_size( GTK_WINDOW( dialog ), -1, 374);
	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);
	gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 6);

	dialog_vbox = GTK_DIALOG (dialog)->vbox;
	gtk_box_set_spacing (GTK_BOX (GTK_DIALOG (dialog)->vbox), 6);

	vbox = gtk_vbox_new (FALSE, 6);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);
	gtk_box_pack_start (GTK_BOX (dialog_vbox), vbox, TRUE, TRUE, 0);
	

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_set_spacing (GTK_BOX(hbox), 6);
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 0);
	image = gtk_image_new_from_stock (GTK_STOCK_DIALOG_INFO, GTK_ICON_SIZE_DIALOG);
	label = gtk_label_new (label_text);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), image, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, FALSE, 0);
	gtk_widget_show_all (hbox);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 0);
	gtk_widget_show (scrolledwindow1);
	gtk_box_pack_start (GTK_BOX (vbox), scrolledwindow1, TRUE, TRUE, 0);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	titles[0] = _("UIN");
	titles[1] = _("Nickname");

	clist1 = gtk_clist_new_with_titles (2, titles);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 0, 65);
	gtk_clist_set_column_width (GTK_CLIST (clist1), 1, 80);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), clist1);
	gtk_widget_show (clist1);

	/* Some dialogs do not need initialization */
	/* TODO: move this into separate function */
	if( is_in_list != NULL )
	{
		contact = Contacts;

		while( contact != NULL )
		{
			if( is_in_list( kontakt ) )
			{
				luin = kontakt->uin;
				lnick = kontakt->nick;
				buf[0] = luin;
				buf[1] = lnick;
				gtk_clist_append( GTK_CLIST( clist1 ), buf );
			}
			contact = contact->next;
		}
	}
	
	gtk_drag_dest_set( clist1, GTK_DEST_DEFAULT_ALL, target_table, 1,
	                   GDK_ACTION_COPY | GDK_ACTION_MOVE );
	g_signal_connect( G_OBJECT( clist1 ), "drag_data_received",
	                  G_CALLBACK( label_drag_data_received ), clist1 );

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

	hbuttonbox3 = gtk_hbutton_box_new ();
	gtk_box_set_spacing (GTK_BOX (hbuttonbox3), 5);
	gtk_box_pack_start (GTK_BOX (hbox), hbuttonbox3, TRUE, TRUE, 0);

	info_button = gtk_button_new_with_label (_("User's Info"));
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), info_button);
	g_signal_connect( G_OBJECT( info_button ), "clicked",
	                  G_CALLBACK( info_list_candidate ),
	                  clist1 );

	remove_button = gtk_button_new_with_label (_("Remove User"));
	gtk_container_add (GTK_CONTAINER (hbuttonbox3), remove_button);
	g_signal_connect( G_OBJECT( remove_button ), "clicked",
	                  G_CALLBACK( remove_contact_list_candidate ),
	                  clist1 );

	gtk_widget_show_all (hbox);

	custom_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
	                                       GTK_STOCK_CLOSE,
	                                       GTK_RESPONSE_CLOSE);
	g_signal_connect_swapped( G_OBJECT( custom_button ), "clicked",
	                          G_CALLBACK( gtk_widget_destroy ), dialog );

	if (button_pixmap) {
		custom_button = make_button_with_pixmap (button_name, button_pixmap);
		gtk_dialog_add_action_widget (GTK_DIALOG (dialog),
		                              custom_button,
		                              GTK_RESPONSE_OK);
	} else {
		custom_button = gtk_dialog_add_button (GTK_DIALOG (dialog),
		                                       button_name,
		                                       GTK_RESPONSE_OK);
	}
	g_signal_connect_data( G_OBJECT( custom_button ), "clicked",
			       G_CALLBACK( gtk_widget_destroy ), dialog ,
			       NULL, G_CONNECT_AFTER | G_CONNECT_SWAPPED );

	gtk_dialog_set_default_response (GTK_DIALOG (dialog), GTK_RESPONSE_OK);

	g_signal_connect (G_OBJECT (custom_button), "clicked",
			  button_clicked, clist1);

	g_signal_connect (G_OBJECT (dialog), "delete_event",
	                  G_CALLBACK (gtk_widget_destroy), NULL);

	g_object_set_data (G_OBJECT (dialog), "clist", clist1);
	g_object_set_data (G_OBJECT (custom_button), "dlg", dialog);
	g_object_set_data (G_OBJECT (dialog), "button", custom_button);

	return dialog;
}

void remove_contact_list_candidate( GtkWidget *widget, gpointer data )
{
	GtkWidget *clist;

	clist = GTK_WIDGET( data );

	gtk_clist_remove( GTK_CLIST( clist ), GTK_CLIST( clist )->focus_row );
}

void info_list_candidate( GtkWidget *widget, gpointer data )
{
	GtkWidget *clist;
	UIN_T uin;
	gchar *text;
	GSList *contact;
	int res;

	if (!is_connected(GTK_WINDOW(g_object_get_data (G_OBJECT (widget), "dlg")), _("You can not request user informations while being disconnected.")))
		return;

	clist = GTK_WIDGET( data );
	if( clist == NULL )
		return;

	res = gtk_clist_get_text( GTK_CLIST( clist ), GTK_CLIST( clist )->focus_row, 0, &text );

	if( res == 0 || text == NULL || text[0] == '\0' )
		return;

	uin = g_strdup (text);

	contact = Find_User( uin );
	if( contact == NULL )
		return;

	v7_request_info (mainconnection, uin);
	dump_personal_info (uin);
	g_free (uin);
}

void label_drag_data_received (GtkWidget *widget, GdkDragContext *context,
                               gint x, gint y, GtkSelectionData *data,
                               guint info, guint time)
{
	gchar *str;
	gchar *uin, *nick;
	gchar *ptr_uin;
	gchar *buf[2];

	if( data == NULL || data->data == NULL )
		return;

	str = g_strdup( (gchar*)data->data );

	nick = strchr( str, '\n' );
	nick[0] = 0;
	uin = str;
	nick++;
	if ((data->length >= 0) && (data->format == 8))
	{
		/* check if the uin is already in list, yes to ignore, no to append. */
		int cx;
		for ( cx = 0; cx < GTK_CLIST( widget )->rows; cx ++ )
		{
			gtk_clist_get_text( GTK_CLIST( widget ), cx, 0, &ptr_uin);
			if ( !strcmp (ptr_uin, uin)) break;
		}
		/* If the uin is already in list, the cx will be small than */
		/* GTK_CLIST( widget )->rows. If you want notify the user */
		/* that the user is already in list, try else :) */
		if (cx == GTK_CLIST( widget )->rows) {
			buf[0] = uin;
			buf[1] = nick;
			gtk_clist_append( GTK_CLIST( widget ), buf );
		}
		gtk_drag_finish (context, TRUE, FALSE, time);
	}
	/* the g_free should be the same level as g_strdup. */
	/* Otherwise, It may cause the memory leak. */
	g_free( str );

	gtk_drag_finish (context, FALSE, FALSE, time);
}
