/***************************************************************************
                            kde_DCOPStub.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_DCOPSTUB
#define KDE_DCOPSTUB

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Abstract base class for dcop stubs as created by the
 dcopidl2cpp compiler.

 @short *
 Abstract base class for dcop stubs as created by the
 dcopidl2cpp compiler.
*/
#define DCOPSTUB_CallSucceeded	0
#define DCOPSTUB_CallFailed	1

/** *
       Creates a DCOPStub for application @p app and object @p obj

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_DCOPStub * kde_new_DCOPStub(qt_QCString* app, qt_QCString* obj);

/** * 
      Creates a DCOPStub for application @p app and object @p obj
       that operates on the DCOPClient @p client

*/
kde_DCOPStub * kde_new_DCOPStub1(kde_DCOPClient* client, qt_QCString* app, qt_QCString* obj);
void kde_del_DCOPStub( kde_DCOPStub* p );

/** *
       Return the application id.

*/
qt_QCString* kde_DCOPStub_app(kde_DCOPStub* instPointer);

/** *
       Return the object  id.

*/
qt_QCString* kde_DCOPStub_obj(kde_DCOPStub* instPointer);

/** *
 Return the status of the last call, either @p CallSucceeded or
 @p CallFailed.

*/
int kde_DCOPStub_status(kde_DCOPStub* instPointer);

/** *
 Return whether no error occured,

*/
int kde_DCOPStub_ok(kde_DCOPStub* instPointer);
#ifdef __cplusplus
}
#endif
#define DCOPSTUB_never_use	0

/** *
       Sets the status to status. Possible values are 'CallSucceeded' and 'CallFailed'

*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_DCOPStub_setStatus(kde_DCOPStub* instPointer,int _status);

/** *
      Invoked whenever a call fails.  The default implementation
      sets the status to CallFailed.
     
*/
void kde_DCOPStub_callFailed(kde_DCOPStub* instPointer);

/** * 
      The dcopClient this stub operates on. Either the specific one
       specified in the constructor or DCOPClient::mainClient.

*/
kde_DCOPClient* kde_DCOPStub_dcopClient(kde_DCOPStub* instPointer);

/** *

*/
kde_DCOPStub * kde_new_DCOPStub2(int arg1);
void kde_DCOPStub_virtual_hook(kde_DCOPStub* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
