/***************************************************************************
                            kde_HTMLInputElement.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLINPUTELEMENT
#define KDE_HTMLINPUTELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Form control. Note. Depending upon the environment the page is
 being viewed, the value property may be read-only for the file
 upload input type. For the "password" input type, the actual value
 returned may be masked to prevent unauthorized use. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-INPUT">
 INPUT element definition </a> in HTML 4.0.

 
 @short *
 Form control.
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_HTMLInputElement * kde_new_HTMLInputElement();
kde_HTMLInputElement * kde_new_HTMLInputElement1(kde_HTMLInputElement* other);
kde_HTMLInputElement * kde_new_HTMLInputElement2(kde_DOMNode* other);
void kde_del_HTMLInputElement( kde_HTMLInputElement* p );

/** *
 Stores the initial control value (i.e., the initial value of
 <code> value </code> ).

     
*/
kde_DOMString* kde_HTMLInputElement_defaultValue(kde_HTMLInputElement* instPointer);

/** *
 see @ref defaultValue
     
*/
void kde_HTMLInputElement_setDefaultValue(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 When <code> type </code> has the value "Radio" or "Checkbox",
 stores the initial value of the <code> checked </code>
 attribute.

     
*/
int kde_HTMLInputElement_defaultChecked(kde_HTMLInputElement* instPointer);

/** *
 see @ref defaultChecked
     
*/
void kde_HTMLInputElement_setDefaultChecked(kde_HTMLInputElement* instPointer,int arg1);

/** *

     
*/
kde_HTMLFormElement* kde_HTMLInputElement_form(kde_HTMLInputElement* instPointer);

/** *
 A comma-separated list of content types that a server
 processing this form will handle correctly. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accept">
 accept attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_accept(kde_HTMLInputElement* instPointer);

/** *
 see @ref accept
     
*/
void kde_HTMLInputElement_setAccept(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 A single character access key to give access to the form
 control. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-accesskey">
 accesskey attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_accessKey(kde_HTMLInputElement* instPointer);

/** *
 see @ref accessKey
     
*/
void kde_HTMLInputElement_setAccessKey(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 Aligns this object (vertically or horizontally) with respect to
 its surrounding text. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-align-IMG">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_align(kde_HTMLInputElement* instPointer);

/** *
 see @ref align
     
*/
void kde_HTMLInputElement_setAlign(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 Alternate text for user agents not rendering the normal content
 of this element. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-alt">
 alt attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_alt(kde_HTMLInputElement* instPointer);

/** *
 see @ref alt
     
*/
void kde_HTMLInputElement_setAlt(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 Describes whether a radio or check box is checked, when <code>
 type </code> has the value "Radio" or "Checkbox". The value is
 TRUE if explicitly set. Represents the current state of the
 checkbox or radio button. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-checked">
 checked attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLInputElement_checked(kde_HTMLInputElement* instPointer);

/** *
 see @ref checked
     
*/
void kde_HTMLInputElement_setChecked(kde_HTMLInputElement* instPointer,int arg1);

/** *
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLInputElement_disabled(kde_HTMLInputElement* instPointer);

/** *
 see @ref disabled
     
*/
void kde_HTMLInputElement_setDisabled(kde_HTMLInputElement* instPointer,int arg1);

/** *
 Maximum number of characters for text fields, when <code> type
 </code> has the value "Text" or "Password". See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-maxlength">
 maxlength attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLInputElement_maxLength(kde_HTMLInputElement* instPointer);

/** *
 see @ref maxLength
     
*/
void kde_HTMLInputElement_setMaxLength(kde_HTMLInputElement* instPointer,long arg1);

/** *
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-INPUT">
 name attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_name(kde_HTMLInputElement* instPointer);

/** *
 see @ref name
     
*/
void kde_HTMLInputElement_setName(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 This control is read-only. When <code> type </code> has the
 value "text" or "password" only. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-readonly">
 readonly attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLInputElement_readOnly(kde_HTMLInputElement* instPointer);

/** *
 see @ref readOnly
     
*/
void kde_HTMLInputElement_setReadOnly(kde_HTMLInputElement* instPointer,int arg1);

/** *
 Size information. The precise meaning is specific to each type
 of field. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-size-INPUT">
 size attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_size(kde_HTMLInputElement* instPointer);

/** *
 see @ref size
     
*/
void kde_HTMLInputElement_setSize(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 When the <code> type </code> attribute has the value "Image",
 this attribute specifies the location of the image to be used
 to decorate the graphical submit button. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-src">
 src attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_src(kde_HTMLInputElement* instPointer);

/** *
 see @ref src
     
*/
void kde_HTMLInputElement_setSrc(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
long kde_HTMLInputElement_tabIndex(kde_HTMLInputElement* instPointer);

/** *
 see @ref tabIndex
     
*/
void kde_HTMLInputElement_setTabIndex(kde_HTMLInputElement* instPointer,long arg1);

/** *
 The type of control created. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-type-INPUT">
 type attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_type(kde_HTMLInputElement* instPointer);

/** *
 see @ref type
     
*/
void kde_HTMLInputElement_setType(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 Use client-side image map. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.html#adef-usemap">
 usemap attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_useMap(kde_HTMLInputElement* instPointer);

/** *
 see @ref useMap
     
*/
void kde_HTMLInputElement_setUseMap(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 The current form control value. Used for radio buttons and
 check boxes. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-value-INPUT">
 value attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLInputElement_value(kde_HTMLInputElement* instPointer);

/** *
 see @ref value
     
*/
void kde_HTMLInputElement_setValue(kde_HTMLInputElement* instPointer,kde_DOMString* arg1);

/** *
 Removes keyboard focus from this element.

     
*/
void kde_HTMLInputElement_blur(kde_HTMLInputElement* instPointer);

/** *
 Gives keyboard focus to this element.

     
*/
void kde_HTMLInputElement_focus(kde_HTMLInputElement* instPointer);

/** *
 Select the contents of the text area. For <code> INPUT </code>
 elements whose <code> type </code> attribute has one of the
 following values: "Text", "File", or "Password".

     
*/
void kde_HTMLInputElement_select(kde_HTMLInputElement* instPointer);

/** *
 Simulate a mouse-click. For <code> INPUT </code> elements whose
 <code> type </code> attribute has one of the following values:
 "Button", "Checkbox", "Radio", "Reset", or "Submit".
     
*/
void kde_HTMLInputElement_click(kde_HTMLInputElement* instPointer);

#ifdef __cplusplus
}
#endif
#endif
