/***************************************************************************
                            kde_KDCOPActionProxy.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDCOPACTIONPROXY
#define KDE_KDCOPACTIONPROXY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The KDCOPActionProxy class provides an easy way to publish a collection of @ref KAction objects
 through DCOP. For the DCOP client the exported actions behave like full-fledged DCOP objects,
 providing full access to the KAction object functionality in the server.

 This class can generate DCOP object ids for given action objects, which it automatically
 processes, as being a @ref DCOPObjectProxy .

 @short A proxy class publishing a DCOP interface for actions.
 
*/

/** *
 Constructs a dcop action proxy, being able to export the actions of the provided
 @ref KActionCollection through DCOP, using the parent DCOPObject's object id to
 generate unique object ids for the actions.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KDCOPActionProxy * kde_new_KDCOPActionProxy(kde_KActionCollection* actionCollection, kde_DCOPObject* parent);

/** *
 Use this constructor if do not want to provide the exportable actions through a
 @ref KActionCollection . You have to reimplement the virtual @ref #actions() and
 @ref #action() methods if you use this constructor.
   
*/
kde_KDCOPActionProxy * kde_new_KDCOPActionProxy1(kde_DCOPObject* parent);

/** *
 Destructor.
   
*/
void kde_del_KDCOPActionProxy( kde_KDCOPActionProxy* p );

/** *
 Returns an action object with the given name. The default implementation queries the action object
 from the @ref KActionCollection, if the first constructor has been used.
   
*/
kde_KAction* kde_KDCOPActionProxy_action(kde_KDCOPActionProxy* instPointer,char* name);

/** *
 Use this method to retrieve a DCOP object id for an action with the given name.
 This class automatically takes care of processing DCOP object requests for the returned
 object id.

 You can construct a global DCOP object referenence using DCOPRef. For example like
 DCOPRef( kapp->dcopClient()->appId, actionProxy->actionObjectId( actionName ) );

 The action with the given name has to be available through the #action method.
   
*/
qt_QCString* kde_KDCOPActionProxy_actionObjectId(kde_KDCOPActionProxy* instPointer,qt_QCString* name);

/** *
 Internal reimplementation of @ref DCOPObjectProxy::process .
   
*/
int kde_KDCOPActionProxy_process(kde_KDCOPActionProxy* instPointer,qt_QCString* obj, qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData);

/** *
 Called by the #process method and takes care of processing the object request for an
 action object.
   
*/
int kde_KDCOPActionProxy_processAction(kde_KDCOPActionProxy* instPointer,qt_QCString* obj, qt_QCString* fun, qt_QByteArray* data, qt_QCString* replyType, qt_QByteArray* replyData, kde_KAction* action);
void kde_KDCOPActionProxy_virtual_hook(kde_KDCOPActionProxy* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
