/***************************************************************************
                            kde_KDirLister.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDIRLISTER
#define KDE_KDIRLISTER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The dir lister deals with the kiojob used to list and update a directory
 and has signals for the user of this class (e.g. konqueror view or
 kdesktop) to create/destroy its items when asked.

 This class is independent from the graphical representation of the dir
 (icon container, tree view, ...) and it stores the items (as KFileItems).

 Typical usage :
 Create an instance.
 Connect to at least update, clear, newItem, and deleteItem.
 Call openURL - the signals will be called.
 Reuse the instance when opening a new url (openURL).
 Destroy the instance when not needed anymore (usually destructor).

 Advanced usage : call openURL with _keep = true to list directories
 without forgetting the ones previously read (e.g. for a tree view)

 @short Helper class for the kiojob used to list and update a directory.
 
*/
#define KDIRLISTER_AllItems	0
#define KDIRLISTER_FilteredItems	1

/** *
 Create a directory lister.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KDirLister * kde_new_KDirLister(int _delayedMimeTypes);

/** *
 Destroy the directory lister.
   
*/
void kde_del_KDirLister( kde_KDirLister* p );

/** *
 Run the directory lister on the given url.

 This method causes KDirLister to emit _all_ the items of @p _url, in any case.
 Depending on @p _keep either clear() or clear( const KURL & ) will be
 emitted first.

 The @ref newItems() signal may be emitted more than once to supply you
 with KFileItems, up until the signal @ref completed() is emitted
 (and @ref isFinished() returns true).
   
*/
int kde_KDirLister_openURL(kde_KDirLister* instPointer,kde_KURL* _url, int _keep, int _reload);

/** *
 Stop listing all directories currently being listed.

 Emits @ref canceled() if there was at least one job running.
 Emits @ref canceled( const KURL& ) for each stopped job if
 there are at least two dirctories being watched by KDirLister.
   
*/
void kde_KDirLister_stop(kde_KDirLister* instPointer);

/** *
 Stop listing the given directory.

 Emits @ref canceled() if the killed job was the last running one.
 Emits @ref canceled( const KURL& ) for the killed job if
 there are at least two directories being watched by KDirLister.
 No signal is emitted if there was no job running for @p _url.

*/
void kde_KDirLister_stop1(kde_KDirLister* instPointer,kde_KURL* _url);

/** *

*/
int kde_KDirLister_autoUpdate(kde_KDirLister* instPointer);

/** *
 Enable/disable automatic directory updating, when a directory changes
 (using KDirWatch).
   
*/
void kde_KDirLister_setAutoUpdate(kde_KDirLister* instPointer,int enable);

/** *
 Error handling.
   
*/
int kde_KDirLister_autoErrorHandlingEnabled(kde_KDirLister* instPointer);
void kde_KDirLister_setAutoErrorHandlingEnabled(kde_KDirLister* instPointer,int enable, qt_QWidget * parent);

/** *

*/
int kde_KDirLister_showingDotFiles(kde_KDirLister* instPointer);

/** *
 Changes the "is viewing dot files" setting.
 Calls @ref updateDirectory() if setting changed
   
*/
void kde_KDirLister_setShowingDotFiles(kde_KDirLister* instPointer,int _showDotFiles);

/** *

*/
int kde_KDirLister_dirOnlyMode(kde_KDirLister* instPointer);

/** *
 Call this with @p dirsOnly == true to list only directories
   
*/
void kde_KDirLister_setDirOnlyMode(kde_KDirLister* instPointer,int dirsOnly);

/** *

*/
kde_KURL* kde_KDirLister_url(kde_KDirLister* instPointer);

/** *
 actually emit the changes made with setShowingDotFiles, setDirOnlyMode,
 setNameFilter and setMimeFilter.
   
*/
void kde_KDirLister_emitChanges(kde_KDirLister* instPointer);

/** *
 Update the directory @p _dir. This method causes KDirLister to _only_ emit
 the items of @p _dir that actually changed compared to the current state in the
 cache and updates the cache.

 The current implementation calls updateDirectory automatically for
 local files, using KDirWatch (if autoUpdate() is true), but it might be
 useful to force an update manually.

*/
void kde_KDirLister_updateDirectory(kde_KDirLister* instPointer,kde_KURL* _dir);

/** *
 Returns true if no io operation is currently in progress.
   
*/
int kde_KDirLister_isFinished(kde_KDirLister* instPointer);

/** *

*/
kde_KFileItem* kde_KDirLister_rootItem(kde_KDirLister* instPointer);

/** *
 Find an item by its URL

*/
kde_KFileItem* kde_KDirLister_findByURL(kde_KDirLister* instPointer,kde_KURL* _url);
kde_KFileItem* kde_KDirLister_find(kde_KDirLister* instPointer,kde_KURL* _url);

/** *
 Find an item by its name

*/
kde_KFileItem* kde_KDirLister_findByName(kde_KDirLister* instPointer,qt_QString * name);

/** *
 Set a name filter to only list items matching this name, e.g. "*.cpp".

 You can set more than one filter by separating them with whitespace, e.g
 "*.cpp *.h".
 Call setNameFilter( QString::null ) to disable filtering.
 Note: the direcory is not automatically reloaded.

*/
void kde_KDirLister_setNameFilter(kde_KDirLister* instPointer,qt_QString * arg1);

/** *

*/
qt_QString * kde_KDirLister_nameFilter(kde_KDirLister* instPointer);

/** *
 Set mime-based filter to only list items matching the given mimetypes

 NOTE: setting the filter does not automatically reload direcory.
 Also calling this function will not affect any named filter already set.

*/
void kde_KDirLister_setMimeFilter(kde_KDirLister* instPointer,qt_QStringList* arg1);

/** *
 Filtering should be done with KFileFilter. This will be implemented in a later
 revision of KDirLister. This method may be removed then.

 Set mime-based exclude filter to only list items not matching the given mimetypes

 NOTE: setting the filter does not automatically reload direcory.
 Also calling this function will not affect any named filter already set.

   
*/
void kde_KDirLister_setMimeExcludeFilter(kde_KDirLister* instPointer,qt_QStringList* arg1);

/** *
 Clears the mime based filter.

*/
void kde_KDirLister_clearMimeFilter(kde_KDirLister* instPointer);

/** *

*/
qt_QStringList* kde_KDirLister_mimeFilters(kde_KDirLister* instPointer);

/** *

*/
int kde_KDirLister_matchesFilter(kde_KDirLister* instPointer,qt_QString * name);

/** *

*/
int kde_KDirLister_matchesMimeFilter(kde_KDirLister* instPointer,qt_QString * mime);

/** *
 Pass the main window this object is associated with
 this is used for caching authentication data

*/
void kde_KDirLister_setMainWindow(kde_KDirLister* instPointer,qt_QWidget * window);

/** *
 Returns the main window associated with this object.

*/
qt_QWidget * kde_KDirLister_mainWindow(kde_KDirLister* instPointer);

/** *
 Returns the items listed for the current @ref url().
 This method will NOT start listing a directory, you should only call
 this when receiving the @ref finished() signal.

 The items in the @ref KFileItemList are references to the items used
 by KDirLister, so e.g. an item gets destroyed when the @ref deleteItem()
 signal is emitted.

*/
kde_KFileItemList* kde_KDirLister_items(kde_KDirLister* instPointer,int which);

/** *
 Returns the items listed for the given @p dir.
 This method will NOT start listing @p dir, you should only call
 this when receiving the @ref finished() signal.

 The items in the @ref KFileItemList are references to the items used
 by KDirLister, so e.g. an item gets destroyed when the @ref deleteItem()
 signal is emitted.

*/
kde_KFileItemList* kde_KDirLister_itemsForDir(kde_KDirLister* instPointer,kde_KURL* dir, int which);
#ifdef __cplusplus
}
#endif
#define KDIRLISTER_NONE	0
#define KDIRLISTER_NAME_FILTER	1
#define KDIRLISTER_MIME_FILTER	2
#define KDIRLISTER_DOT_FILES	4
#define KDIRLISTER_DIR_ONLY_MODE	8

/** *
 Called for every new item before emitting @ref newItems().

*/
#ifdef __cplusplus
extern   "C" {
#endif
int kde_KDirLister_matchesFilter1(kde_KDirLister* instPointer,kde_KFileItem* arg1);
int kde_KDirLister_matchesMimeFilter1(kde_KDirLister* instPointer,kde_KFileItem* arg1);
int kde_KDirLister_doMimeFilter(kde_KDirLister* instPointer,qt_QString * mime, qt_QStringList* filters);

/** *

   
*/
int kde_KDirLister_doMimeExcludeFilter(kde_KDirLister* instPointer,qt_QString * mimeExclude, qt_QStringList* filters);

/** *
 Checks if an url is malformed or not and displays an error message
 if it is and autoErrorHandling is set to true.

*/
int kde_KDirLister_validURL(kde_KDirLister* instPointer,kde_KURL* arg1);

/** * Reimplement to customize error handling 
*/
void kde_KDirLister_handleError(kde_KDirLister* instPointer,kde_Job* arg1);
void kde_KDirLister_virtual_hook(kde_KDirLister* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
