/***************************************************************************
                            kde_KEditListBox.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KEDITLISTBOX
#define KDE_KEDITLISTBOX

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 An editable listbox

 This class provides a editable listbox ;-), this means
 a listbox which is accompanied by a line edit to enter new
 items into the listbox and pushbuttons to add and remove
 items from the listbox and two buttons to move items up and down.
 
 @short *
 An editable listbox

*/
#define KEDITLISTBOX_Add	1
#define KEDITLISTBOX_Remove	2
#define KEDITLISTBOX_UpDown	4
#define KEDITLISTBOX_All	KEDITLISTBOX_Add|KEDITLISTBOX_Remove|KEDITLISTBOX_UpDown

/** *
 Create an editable listbox.

 If @p checkAtEntering is true, after every character you type
 in the line edit KEditListBox will enable or disable
 the Add-button, depending whether the current content of the
 line edit is already in the listbox. Maybe this can become a
 performance hit with large lists on slow machines.
 If @p checkAtEntering is false,
 it will be checked if you press the Add-button. It is not
 possible to enter items twice into the listbox.
       
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KEditListBox * kde_new_KEditListBox(qt_QWidget * parent, char* name, int checkAtEntering, int buttons);

/** *
 Create an editable listbox.

 The same as the other constructor, additionally it takes
 @title, which will be the title of the frame around the listbox.
       
*/
kde_KEditListBox * kde_new_KEditListBox1(qt_QString * title, qt_QWidget * parent, char* name, int checkAtEntering, int buttons);

/** *
 Another constructor, which allows to use a custom editing widget
 instead of the standard KLineEdit widget. E.g. you can use a 
 @ref KURLRequester or a @ref KComboBox as input widget. The custom
 editor must consist of a lineedit and optionally another widget that
 is used as representation. A KComboBox or a KURLRequester have a
 KLineEdit as child-widget for example, so the KComboBox is used as
 the representation widget.

*/
void kde_del_KEditListBox( kde_KEditListBox* p );

/** *
 Return a pointer to the embedded QListBox.
       
*/
qt_QListBox * kde_KEditListBox_listBox(kde_KEditListBox* instPointer);

/** *
 Return a pointer to the embedded QLineEdit.
       
*/
kde_KLineEdit* kde_KEditListBox_lineEdit(kde_KEditListBox* instPointer);

/** *
 Return a pointer to the Add button
       
*/
qt_QPushButton* kde_KEditListBox_addButton(kde_KEditListBox* instPointer);

/** *
 Return a pointer to the Remove button
       
*/
qt_QPushButton* kde_KEditListBox_removeButton(kde_KEditListBox* instPointer);

/** *
 Return a pointer to the Up button
       
*/
qt_QPushButton* kde_KEditListBox_upButton(kde_KEditListBox* instPointer);

/** *
 Return a pointer to the Down button
       
*/
qt_QPushButton* kde_KEditListBox_downButton(kde_KEditListBox* instPointer);

/** *
 See @ref QListBox::count()
       
*/
int kde_KEditListBox_count(kde_KEditListBox* instPointer);

/** *
 See @ref QListBox::insertStringList()
       
*/
void kde_KEditListBox_insertStringList(kde_KEditListBox* instPointer,qt_QStringList* list, int index);

/** *
 See @ref QListBox::insertStringList()
       
*/
void kde_KEditListBox_insertStrList(kde_KEditListBox* instPointer,qt_QStrList * list, int index);

/** *
 See @ref QListBox::insertStrList()
       
*/
void kde_KEditListBox_insertStrList1(kde_KEditListBox* instPointer,qt_QStrList * list, int index);

/** *
 See @ref QListBox::insertStrList()
       
*/
void kde_KEditListBox_insertStrList2(kde_KEditListBox* instPointer,char** list, int numStrings, int index);

/** *
 See @ref QListBox::insertItem()
       
*/
void kde_KEditListBox_insertItem(kde_KEditListBox* instPointer,qt_QString * text, int index);

/** *
 Clears both the listbox and the line edit.
       
*/
void kde_KEditListBox_clear(kde_KEditListBox* instPointer);

/** *
 See @ref QListBox::text()
       
*/
qt_QString * kde_KEditListBox_text(kde_KEditListBox* instPointer,int index);

/** *
 See @ref QListBox::currentItem()
       
*/
int kde_KEditListBox_currentItem(kde_KEditListBox* instPointer);

/** *
 See @ref QListBox::currentText()
       
*/
qt_QString * kde_KEditListBox_currentText(kde_KEditListBox* instPointer);

/** *

*/
qt_QStringList* kde_KEditListBox_items(kde_KEditListBox* instPointer);
void kde_KEditListBox_virtual_hook(kde_KEditListBox* instPointer,int identifier, void* data);
void kde_KEditListBox_moveItemUp(kde_KEditListBox* instPointer);
void kde_KEditListBox_moveItemDown(kde_KEditListBox* instPointer);
void kde_KEditListBox_addItem(kde_KEditListBox* instPointer);
void kde_KEditListBox_removeItem(kde_KEditListBox* instPointer);
void kde_KEditListBox_enableMoveButtons(kde_KEditListBox* instPointer,int index);
void kde_KEditListBox_typedSomething(kde_KEditListBox* instPointer,qt_QString * text);

#ifdef __cplusplus
}
#endif
#endif
