/***************************************************************************
                            kde_KLibrary.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLIBRARY
#define KDE_KLIBRARY

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*

 KLibrary allows you to look up symbols of the shared library.

 @author Torben Weis <weis@kde.org>
 
 @short Represents a dynamically loaded library.

*/

/** *

 Don't create KLibrary objects on your own. Instead use @ref KLibLoader.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KLibrary * kde_new_KLibrary(qt_QString * libname, qt_QString * filename, void* handle);

/** *
 Returns the name of the library.

*/
qt_QString * kde_KLibrary_name(kde_KLibrary* instPointer);

/** *
 Returns the file name of the library.

*/
qt_QString * kde_KLibrary_fileName(kde_KLibrary* instPointer);

/** *
 Returns the factory of the library.

*/
kde_KLibFactory* kde_KLibrary_factory(kde_KLibrary* instPointer);

/** *
 Looks up a symbol from the library. This is a very low level
 function that you usually don't want to use. Usually you should
 check using @ref hasSymbol() whether the symbol actually exists,
 otherwise a warning will be printed.

*/
void* kde_KLibrary_symbol(kde_KLibrary* instPointer,char* name);

/** *
 Looks up a symbol from the library. This is a very low level
 function that you usually don't want to use.
 Unlike @ref #symbol(), this method doesn't warn if the symbol doesn't exist,
 so if the symbol might or might not exist, better use hasSymbol() before symbol().

*/
int kde_KLibrary_hasSymbol(kde_KLibrary* instPointer,char* name);

/** *
 Unloads the library.
 This typically results in the deletion of this object. You should
 not reference its pointer after calling this function.
     
*/
void kde_KLibrary_unload(kde_KLibrary* instPointer);

#ifdef __cplusplus
}
#endif
#endif
