/***************************************************************************
                            kde_KMultipleDrag.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KMULTIPLEDRAG
#define KDE_KMULTIPLEDRAG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.

 Instead of creating a specific class for each case (as would otherwise
 be necessary), you can simply create independent drag objects (e.g.
 a QImageDrag object and a KURLDrag object), and bundle them together
 using KMultipleDrag.

 Sample code for this:

 <pre>
 KMultipleDrag *drag = new KMultipleDrag( parentWidget );
 drag->addDragObject( new QImageDrag( someQImage, 0L ) );
 drag->addDragObject( KURLDrag::newDrag( someKURL, 0L ) );
 drag->drag();
 </pre>

 Note that the drag objects added to the multiple drag become owned by it.
 For that reason their parent should be 0L.

 @author David Faure <david@mandrakesoft.com>
 
 @short *
 This class makes it easy for applications to provide a drag object
 (for drag-n-drop or for clipboard) that has several representations
 of the same data, under different formats.
*/

/** *
 Create a new KMultipleDrag object.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KMultipleDrag * kde_new_KMultipleDrag(qt_QWidget * dragSource, char* name);

/** *
 Call this to add each underlying drag object to the multiple drag object.
 The drag object should not have a parent because the multiple drag object
 will own it.

*/
void kde_KMultipleDrag_addDragObject(kde_KMultipleDrag* instPointer,qt_QDragObject* dragObject);

/** * 
 Returns the data of a drag object with that supports the given
 mime type.

*/
qt_QByteArray* kde_KMultipleDrag_encodedData(kde_KMultipleDrag* instPointer,char* mime);

/** *
 Returns the @p i'th supported format, or 0.

*/
char* kde_KMultipleDrag_format(kde_KMultipleDrag* instPointer,int i);
void kde_KMultipleDrag_virtual_hook(kde_KMultipleDrag* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
