/***************************************************************************
                            kde_KProgress.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KPROGRESS
#define KDE_KPROGRESS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A stylized progress bar.

 KProgress is derived from @ref QProgressBar, so
 you can use all the methods from that class. The only real difference
 is that a signal is emitted on changes to the value and you do not need
 to subclass KProgress just to change the format of the indicator text. 

 @author Aaron Seigo

 @version $Id: kde_KProgress.h,v 1.5 2002/12/30 14:37:06 geiseri Exp $
 
 @short A progress indicator widget.

*/

/** *
 Construct a progress bar.
   
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KProgress * kde_new_KProgress(qt_QWidget * parent, char* name, int f);

/** *
 Construct a progress bar with a total number of steps.
 The totalSteps is the total number of steps that need to be completed for the operation which this progress
 bar represents. For example, if the operation is to examine 50 files, this value would be 50. Before examining
 the first file, call setProgress(0); call setProgress(50) after examining the last file.
   
*/
kde_KProgress * kde_new_KProgress1(int totalSteps, qt_QWidget * parent, char* name, int f);

/** *
 Destruct the progress bar.
   
*/
void kde_del_KProgress( kde_KProgress* p );

/** *
 If this is set to @p true, the progress text will be displayed.

   
*/
void kde_KProgress_setTextEnabled(kde_KProgress* instPointer,int arg1);

/** *

*/
int kde_KProgress_value(kde_KProgress* instPointer);

/** *
 Returns @p true if progress text will be displayed,
 @p false otherwise.

*/
int kde_KProgress_textEnabled(kde_KProgress* instPointer);

/** *
 Retrieve the current format for printing status text.

*/
qt_QString * kde_KProgress_format(kde_KProgress* instPointer);

/** *

 Use @ref setTotalSteps() instead
   
*/
void kde_KProgress_setRange(kde_KProgress* instPointer,int min, int max);

/** *

   
*/
int kde_KProgress_maxValue(kde_KProgress* instPointer);

/** *
 Set the format of the text to use to display status.

 The default format is "%p%" (which looks like "42%".)

*/
void kde_KProgress_setFormat(kde_KProgress* instPointer,qt_QString * format);

/** *
 Set the current total number of steps in the action tat the progress bar
 is representing.
    
*/
void kde_KProgress_setTotalSteps(kde_KProgress* instPointer,int totalSteps);

/** *

    
*/
void kde_KProgress_setValue(kde_KProgress* instPointer,int progress);

/** *
 Advance the progress bar by @p prog.

 This method is
 provided for convenience and is equivalent with
 @ref setValue(value()+prog).
   
*/
void kde_KProgress_advance(kde_KProgress* instPointer,int offset);
void kde_KProgress_virtual_hook(kde_KProgress* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
