/***************************************************************************
                            kde_Part.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_PART
#define KDE_PART

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Base class for parts.

 A "part" is a GUI component, featuring:

 See also @ref ReadOnlyPart and @ref ReadWritePart, which define the
 framework for a "viewer" part and for an "editor"-like part.
 Use Part directly only if your part doesn't fit into those.
 
 @short *
 Base class for parts.
*/

/** *
  Constructor.

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_Part * kde_new_Part(qt_QObject * parent, char* name);

/** *
  Destructor.
     
*/
void kde_del_Part( kde_Part* p );

/** *
 Embed this part into a host widget.

 You don't need to do this if you created the widget with the
 correct parent widget - this is just a @ref QWidget::reparent().
 Note that the @ref Part is still the holder
 of the @ref QWidget, meaning that if you delete the @ref Part,
 then the widget gets destroyed as well, and vice-versa.
 This method is not recommended since creating the widget with the correct
 parent is simpler anyway.
     
*/
void kde_Part_embed(kde_Part* instPointer,qt_QWidget * parentWidget);

/** *

*/
qt_QWidget * kde_Part_widget(kde_Part* instPointer);

/** *

 Used by the part manager.
     
*/
void kde_Part_setManager(kde_Part* instPointer,kde_PartManager* manager);

/** *
 Returns the part manager handling this part, if any (0L otherwise).
     
*/
kde_PartManager* kde_Part_manager(kde_Part* instPointer);

/** *

     
*/
kde_Part* kde_Part_hitTest(kde_Part* instPointer,qt_QWidget * widget, qt_QPoint* globalPos);

/** *

*/
void kde_Part_setSelectable(kde_Part* instPointer,int selectable);

/** *
  Returns whether the part is selectable or not.
     
*/
int kde_Part_isSelectable(kde_Part* instPointer);

/** *
 Set the main widget.

 Call this in the Part-inherited class constructor.
     
*/
void kde_Part_setWidget(kde_Part* instPointer,qt_QWidget * widget);

/** *

     
*/

/** *
 Convenience method which is called when the Part received a @ref PartActivateEvent .
 Reimplement this if you don't want to reimplement @ref event and test for the event yourself
 or even install an event filter.
     
*/

/** *
 Convenience method which is called when the Part received a
 @ref PartSelectEvent .
 Reimplement this if you don't want to reimplement @ref event and
 test for the event yourself or even install an event filter.
     
*/

/** *
 Convenience method which is called when the Part received a
 @ref GUIActivateEvent .
 Reimplement this if you don't want to reimplement @ref event and
 test for the event yourself or even install an event filter.
     
*/

/** *
 Convenience method for @ref KXMLGUIFactory::container.

*/
qt_QWidget * kde_Part_hostContainer(kde_Part* instPointer,qt_QString * containerName);

/** Casts a 'kde_Part *' to a 'kde_PartBase*' */
kde_PartBase* kde_Part_PartBase(kde_Part* instPointer);

/** Casts a 'kde_Part *' to a 'qt_QObject *' */
qt_QObject * kde_Part_QObject(kde_Part* instPointer);

#ifdef __cplusplus
}
#endif
#endif
