/***************************************************************************
                            kde_StatJob.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_STATJOB
#define KDE_STATJOB

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_StatJob * kde_new_StatJob(kde_KURL* url, int command, qt_QByteArray* packedArgs, int showProgressInfo);

/** * A stat() can have two meanings. Either we want to read from this URL,
 or to check if we can write to it. First case is "source", second is "dest".
 It is necessary to know what the StatJob is for, to tune the kioslave's behaviour
 (e.g. with FTP)
         
*/
void kde_StatJob_setSide(kde_StatJob* instPointer,int source);

/** *
 Selects the level of details we want.
 By default this is 2 (all details wanted, including modification time, size, etc.),
 setDetails(1) is used when deleting: we don't need all the information if it takes
 too much time, no need to follow symlinks etc.
 setDetails(0) is used for very simple probing: we'll only get the answer
 "it's a file or a directory, or it doesn't exist". This is used by KRun.
         
*/
void kde_StatJob_setDetails(kde_StatJob* instPointer,short int details);

/** *
 Call this in the slot connected to @ref #result,
 and only after making sure no error happened.
         
*/

/** *
 Called by the scheduler when a slave gets to
 work on this job.
         
*/
void kde_StatJob_start(kde_StatJob* instPointer,kde_Slave* slave);
void kde_StatJob_virtual_hook(kde_StatJob* instPointer,int identifier, void* data);
void kde_StatJob_slotRedirection(kde_StatJob* instPointer,kde_KURL* url);
void kde_StatJob_slotFinished(kde_StatJob* instPointer);

#ifdef __cplusplus
}
#endif
#endif
