//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QPixmap;

/**

 A KFileItem is a generic class to handle a file, local or remote.
 In particular, it makes it easier to handle the result of KIO.listDir
 (UDSEntry isn't very friendly to use).
 It includes many file attributes such as mimetype, icon, text, mode, link...
 		@short    A KFileItem is a generic class to handle a file, local or remote.

*/
public class KFileItem implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;
	protected KFileItem(Class dummy){}

	public static final int Unknown = -1;

	public static final int Modification = 0;
	public static final int Access = 1;
	public static final int Creation = 2;
	public static final int NumFlags = 3;

	/**	
		 Creates an item representing a file, from a UDSEntry.
		 This is the preferred constructor when using KIO.listDir().
			@param _entry the KIO entry used to get the file, contains info about it
			@param _url the file url
			@param _determineMimeTypeOnDemand specifies if the mimetype of the given
		       URL should be determined immediately or on demand
			@param _urlIsDirectory specifies if the url is just the directory of the
		       fileitem and the filename from the UDSEntry should be used.
		   		@short    Creates an item representing a file, from a UDSEntry.
	*/
	// KFileItem* KFileItem(const KIO::UDSEntry& arg1,const KURL& arg2,bool arg3,bool arg4); >>>> NOT CONVERTED
	// KFileItem* KFileItem(const KIO::UDSEntry& arg1,const KURL& arg2,bool arg3); >>>> NOT CONVERTED
	// KFileItem* KFileItem(const KIO::UDSEntry& arg1,const KURL& arg2); >>>> NOT CONVERTED
	/**	
		 Creates an item representing a file, from all the necessary info for it.
			@param _mode the file mode (according to stat() (e.g. S_IFDIR...)
		 Set to KFileItem.Unknown if unknown. For local files, KFileItem will use stat().
			@param _permissions the access permissions
		 If you set both the mode and the permissions, you save a .stat() for
		 local files.
		 Set to KFileItem.Unknown if you don't know the mode or the permission.
			@param _url the file url
			@param _determineMimeTypeOnDemand specify if the mimetype of the given URL
		       should be determined immediately or on demand
		   		@short    Creates an item representing a file, from all the necessary info for it.
	*/
	public KFileItem(long _mode, long _permissions, KURL _url, boolean _determineMimeTypeOnDemand) {
		newKFileItem(_mode,_permissions,_url,_determineMimeTypeOnDemand);
	}
	private native void newKFileItem(long _mode, long _permissions, KURL _url, boolean _determineMimeTypeOnDemand);
	public KFileItem(long _mode, long _permissions, KURL _url) {
		newKFileItem(_mode,_permissions,_url);
	}
	private native void newKFileItem(long _mode, long _permissions, KURL _url);
	/**	
		 Creates an item representing a file, for which the mimetype is already known.
			@param url the file url
			@param mimeType the name of the file's mimetype
			@param mode the mode (S_IFDIR...)
		   		@short    Creates an item representing a file, for which the mimetype is already known.
	*/
	public KFileItem(KURL url, String mimeType, long mode) {
		newKFileItem(url,mimeType,mode);
	}
	private native void newKFileItem(KURL url, String mimeType, long mode);
	/**	
		 Copy constructor. Note that extra-data set via setExtraData() is not
		 deeply copied -- just the pointers are copied.
		   		@short    Copy constructor.
	*/
	public KFileItem(KFileItem item) {
		newKFileItem(item);
	}
	private native void newKFileItem(KFileItem item);
	/**	
		 Re-reads information (currently only permissions and mimetype).
		 This is called when the _file_ changes.
		   		@short    Re-reads information (currently only permissions and mimetype).
	*/
	public native void refresh();
	/**	
		 Re-reads mimetype information.
		 This is called when the mimetype database changes.
		   		@short    Re-reads mimetype information.
	*/
	public native void refreshMimeType();
	/**	
		 Returns the url of the file.
				@return the url of the file
   
		@short    Returns the url of the file.
	*/
	public native KURL url();
	/**	
		 Sets the item's URL. Do not call unless you know what you are doing!
		 (used for example when an item got renamed).
			@param url the item's URL
		   		@short    Sets the item's URL.
	*/
	public native void setURL(KURL url);
	/**	
		 Sets the item's name (i.e. the filename).
		 This is automatically done by setURL, to set the name from the URL's fileName().
		 This method is provided for some special cases like relative paths as names (KFindPart)
			@param name the item's name
		   		@short    Sets the item's name (i.
	*/
	public native void setName(String name);
	/**	
		 Returns the permissions of the file (stat.st_mode containing only permissions).
				@return the permissions of the file
   
		@short    Returns the permissions of the file (stat.
	*/
	public native long permissions();
	/**	
		 Returns the access permissions for the file as a string.
				@return the access persmission as string
   
		@short    Returns the access permissions for the file as a string.
	*/
	public native String permissionsString();
	/**	
		 Returns the file type (stat.st_mode containing only S_IFDIR, S_IFLNK, ...).
				@return the file type
   
		@short    Returns the file type (stat.
	*/
	public native long mode();
	/**	
		 Returns the owner of the file.
				@return the file's owner
   
		@short    Returns the owner of the file.
	*/
	public native String user();
	/**	
		 Returns the group of the file.
				@return the file's group
   
		@short    Returns the group of the file.
	*/
	public native String group();
	/**	
		 Returns true if this item represents a link in the UNIX sense of
		 a link.
				@return true if the file is a link
   
		@short    Returns true if this item represents a link in the UNIX sense of  a link.
	*/
	public native boolean isLink();
	/**	
		 Returns true if this item represents a directory.
				@return true if the item is a directory
   
		@short    Returns true if this item represents a directory.
	*/
	public native boolean isDir();
	/**	
		 Returns true if this item represents a file (and not a a directory)
				@return true if the item is a file
   
		@short    Returns true if this item represents a file (and not a a directory)
	*/
	public native boolean isFile();
	/**	
		 Checks whether the file is readable. In some cases
		 (remote files), we may return true even though it can't be read.
				@return true if the file can be read - more precisely,
         false if we know for sure it can't
   
		@short    Checks whether the file is readable.
	*/
	public native boolean isReadable();
	/**	
		 Returns the link destination if isLink() == true.
				@return the link destination. null if the item is not a link
   
		@short    Returns the link destination if isLink() == true.
	*/
	public native String linkDest();
	/**	
		 Returns the size of the file, if known.
				@return the file size, or 0 if not known
   
		@short    Returns the size of the file, if known.
	*/
	public native long size();
	/**	
		 Requests the modification, access or creation time, depending on <code>which.</code>
			@param which UDS_MODIFICATION_TIME, UDS_ACCESS_TIME or even UDS_CREATION_TIME
				@return the time asked for, (time_t)0 if not available

		@short    Requests the modification, access or creation time, depending on <code>which.</code>
		@see #timeString
	*/
	public native int time(int which);
	/**	
		 Requests the modification, access or creation time as a string, depending
		 on <code>which.</code>
			@param which UDS_MODIFICATION_TIME, UDS_ACCESS_TIME or even UDS_CREATION_TIME
				@return a formatted string of the requested time.

		@short    Requests the modification, access or creation time as a string, depending  on <code>which.</code>
		@see #time
	*/
	public native String timeString(int which);
	public native String timeString();
	/**	
		 Returns true if the file is a local file.
				@return true if the file is local, false otherwise
   
		@short    Returns true if the file is a local file.
	*/
	public native boolean isLocalFile();
	/**	
		 Returns the text of the file item.
		 It's not exactly the filename since some decoding happens ('%2F'.'/').
				@return the text of the file item
   
		@short    Returns the text of the file item.
	*/
	public native String text();
	/**	
		 Return the name of the file item (without a path).
		 Similar to text(), but unencoded, i.e. the original name.
			@param lowerCase if true, the name will be returned in lower case,
		 which is useful to speed up sorting by name, case insensitively.
				@return the file's name
   
		@short    Return the name of the file item (without a path).
	*/
	public native String name(boolean lowerCase);
	public native String name();
	/**	
		 Returns the mimetype of the file item.
		 If <code>_determineMimeTypeOnDemand</code> was used in the constructor, this will determine
		 the mimetype first. Equivalent to determineMimeType().name()
				@return the mime type of the file
   
		@short    Returns the mimetype of the file item.
	*/
	public native String mimetype();
	/**	
		 Returns the mimetype of the file item.
		 If _determineMimeTypeOnDemand was used in the constructor, this will determine
		 the mimetype first.
				@return the mime type
   
		@short    Returns the mimetype of the file item.
	*/
	// KMimeType::Ptr determineMimeType(); >>>> NOT CONVERTED
	/**	
		 Returns the currently known mimetype of the file item.
		 This will not try to determine the mimetype if unknown.
				@return the known mime type
   
		@short    Returns the currently known mimetype of the file item.
	*/
	// KMimeType::Ptr mimeTypePtr(); >>>> NOT CONVERTED
	public native boolean isMimeTypeKnown();
	/**	
		 Returns the descriptive comment for this mime type, or
		 the mime type itself if none is present.
				@return the mime type description, or the mime type itself
   
		@short    Returns the descriptive comment for this mime type, or  the mime type itself if none is present.
	*/
	public native String mimeComment();
	/**	
		 Returns the full path name to the icon that represents
		 this mime type.
				@return iconName the name of the file's icon
   
		@short    Returns the full path name to the icon that represents  this mime type.
	*/
	public native String iconName();
	/**	
		 Returns a pixmap representing the file.
			@param _size Size for the pixmap in pixels. Zero will return the
		 globally configured default size.
			@param _state The state of the icon: KIcon.DefaultState,
		 KIcon.ActiveState or KIcon.DisabledState.
				@return the pixmap
   
		@short    Returns a pixmap representing the file.
	*/
	public native QPixmap pixmap(int _size, int _state);
	public native QPixmap pixmap(int _size);
	/**	
		 Returns the overlays (bitfield of KIcon.Overlay flags) that are used
		 for this item's pixmap. Overlays are used to show for example, whether
		 a file can be modified.
				@return the overlays of the pixmap
   
		@short    Returns the overlays (bitfield of KIcon. Overlay flags) that are used  for this item's pixmap.
	*/
	public native int overlays();
	/**	
		 Returns the string to be displayed in the statusbar,
		 e.g. when the mouse is over this item
				@return the status bar information
   
		@short    Returns the string to be displayed in the statusbar,  e.
	*/
	public native String getStatusBarInfo();
	/**	
		 Returns the string to be displayed in the tool tip when the mouse
		 is over this item. This may load a plugin to determine additional
		 information specific to the mimetype of the file.
			@param maxcount the maximum number of entries shown
				@return the tool tip string
   
		@short    Returns the string to be displayed in the tool tip when the mouse  is over this item.
	*/
	public native String getToolTipText(int maxcount);
	public native String getToolTipText();
	/**	
		 Returns true if files can be dropped over this item.
		 Contrary to popular belief, not only dirs will return true :)
		 Executables, .desktop files, will do so as well.
				@return true if you can drop files over the item
   
		@short    Returns true if files can be dropped over this item.
	*/
	public native boolean acceptsDrops();
	/**	
		 Let's "KRun" this file !
		 (e.g. when file is clicked or double-clicked or return is pressed)
		   		@short    Let's "KRun" this file !  (e.
	*/
	public native void run();
	/**	
		 Returns the UDS entry. Used by the tree view to access all details
		 by position.
				@return the UDS entry
   
		@short    Returns the UDS entry.
	*/
	// const KIO::UDSEntry& entry(); >>>> NOT CONVERTED
	/**	
		 Used when updating a directory. marked == seen when refreshing.
				@return true if the file item is marked
   
		@short    Used when updating a directory.
	*/
	public native boolean isMarked();
	/**	
		 Marks the item.
				@short    Marks the item.
		@see #isMarked
	*/
	public native void mark();
	/**	
		 Unmarks the item.
				@short    Unmarks the item.
		@see #isMarked
	*/
	public native void unmark();
	/**	
		 Somewhat like a comparison operator, but more explicit.
			@param item the item to compare
				@return true if all values are equal
   
		@short    Somewhat like a comparison operator, but more explicit.
	*/
	public native boolean cmp(KFileItem item);
	/**	
		 This allows to associate some "extra" data to a KFileItem. As one
		 KFileItem can be used by several objects (often views) which all need
		 to add some data, you have to use a key to reference your extra data
		 within the KFileItem.
			 That way a KFileItem can hold and provide access to all those views
		 separately.
			 I.e. a KFileIconView that associates a KFileIconViewItem (an item suitable
		 for use with QIconView) does
			 <pre>
		 kfileItem.setExtraData( this, iconViewItem );
		 </pre>
			 and can later access the iconViewItem by doing
			 <pre>
		 KFileIconViewItem iconViewItem = (KFileIconViewItem)( kfileItem.extraData( this ));
		 </pre>
			 This is usually more efficient then having every view associate data to
		 items by using a separate QDict or QMap.
			 Note: you have to remove and destroy the data you associated yourself
		 when you don't need it anymore!
			@param key the key of the extra data
			@param value the value of the extra data
				@short    This allows to associate some "extra" data to a KFileItem.
		@see #extraData
		@see #removeExtraData
	*/
	// void setExtraData(const void* arg1,void* arg2); >>>> NOT CONVERTED
	/**	
		 Retrieves the extra data with the given <code>key.</code>
			@param key the key of the extra data
				@return the extra data associated to an item with <code>key</code> via
 setExtraData. 0L if nothing was associated with <code>key.</code>

		@short    Retrieves the extra data with the given <code>key.</code>
		@see #extraData
	*/
	// const void* extraData(const void* arg1); >>>> NOT CONVERTED
	// void* extraData(const void* arg1); >>>> NOT CONVERTED
	/**	
		 Removes the extra data associated with an item via <code>key.</code>
			@param key the key of the extra data to remove
		   		@short    Removes the extra data associated with an item via <code>key.</code>
	*/
	// void removeExtraData(const void* arg1); >>>> NOT CONVERTED
	/**	
		 Sets the metainfo of this item to <code>info.</code>
			@param info the new meta info
		   		@short    Sets the metainfo of this item to <code>info.</code>
	*/
	public native void setMetaInfo(KFileMetaInfo info);
	/**	
		 Returns the metainfo of this item.
			@param autoget if true, the metainfo will automatically be created
			@param what ignored
		   		@short    Returns the metainfo of this item.
	*/
	public native KFileMetaInfo metaInfo(boolean autoget, int what);
	public native KFileMetaInfo metaInfo(boolean autoget);
	public native KFileMetaInfo metaInfo();
	/**	
		 Somewhat like an assignment operator, but more explicit.
		 Note: extra-data set with setExtraData() is not copied, so be careful
		 what you do!
			 I.e. KDirLister uses it to update existing items from a fresh item.
			@param item the item to copy
		   		@short    Somewhat like an assignment operator, but more explicit.
	*/
	public native void assign(KFileItem item);
	/**	
		 Computes the text, mode, and mimetype from the UDSEntry
		 Called by constructor, but can be called again later
		   		@short    Computes the text, mode, and mimetype from the UDSEntry  Called by constructor, but can be called again later
	*/
	protected native void init(boolean _determineMimeTypeOnDemand);
	/**	
		 Parses the given permission set and provides it for access()
		   		@short    Parses the given permission set and provides it for access()
	*/
	protected native String parsePermissions(long perm);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
