//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import java.util.ArrayList;
import org.kde.qt.QWidget;
import org.kde.qt.QObject;

/**

 Net Transparency.
 NetAccess allows you to do simple file operation (load, save,
 copy, delete..) without working with KIO.Job directly.
 Whereas a KIO.Job is asynchronous, meaning that the
 developer has to connect slots for it, KIO.NetAccess provides
 synchronous downloads and uploads, as well as temporary file
 creation and removal. The functions appear to be blocking,
 but the Qt event loop continues running while the operations
 are handled. This means that the GUI will not freeze.
 This class isn't meant to be used as a class but only as a simple
 namespace for static functions, though an instance of the class
 is built for internal purposes.
 Port to kio done by David Faure, faure@kde.org
		@short Provides an easy, synchronous interface to KIO file operations.

*/
public class NetAccess extends QObject  {
	protected NetAccess(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Downloads a file from an arbitrary URL (<code>src</code>) to a
		 temporary file on the local filesystem (<code>target</code>).
			 If the argument
		 for <code>target</code> is an empty string, download will generate a
		 unique temporary filename in /tmp. Since <code>target</code> is a reference
		 to String you can access this filename easily. Download will
		 return true if the download was successful, otherwise false.
			 Special case:
		 If the URL is of kind file:, then no downloading is
		 processed but the full filename is returned in <code>target.</code>
		 That means you <b>have</b> to take care about the <code>target</code> argument.
		 (This is very easy to do, please see the example below.)
			 Download is synchronous. That means you can use it like
		 this, (assuming <code>u</code> is a string which represents a URL and your
		 application has a loadFile() function):
			 <pre>
		 String tmpFile;
		 if( KIO.NetAccess.download( u, tmpFile ) )
		 {
		   loadFile( tmpFile );
		   KIO.NetAccess.removeTempFile( tmpFile );
		   }
		 </pre>
			 Of course, your user interface will still process exposure/repaint
		 events during the download.
			@param src URL Reference to the file to download.
			@param target String containing the final local location of the
		               file.  If you insert an empty string, it will
		               return a location in a temporary spot. <B>Note:</B>
		               you are responsible for the removal of this file when
		               you are finished reading it using removeTempFile.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be
		               cached only for a short duration after which the user will
		               again be prompted for passwords as needed.
				@return true if successful, false for failure
     
		@short    Downloads a file from an arbitrary URL (<code>src</code>) to a  temporary file on the local filesystem (<code>target</code>).
	*/
	public static native boolean download(KURL src, StringBuffer target, QWidget window);
	/**	
		 Removes the specified file if and only if it was created
		 by KIO.NetAccess as a temporary file for a former download.
			 Note: This means that if you created your temporary with KTempFile,
		 use KTempFile.unlink() or KTempFile.setAutoDelete() to have
		 it removed.
			@param name Path to temporary file to remove.  May not be
		             empty.
		     		@short    Removes the specified file if and only if it was created  by KIO.NetAccess as a temporary file for a former download.
	*/
	public static native void removeTempFile(String name);
	/**	
		 Uploads file <code>src</code> to URL <code>target.</code>
			 Both must be specified, unlike download.
		 Note that this is assumed to be used for saving a file over
		 the network, so overwriting is set to true. This is not the
		 case with copy.
			@param src URL Referencing the file to upload.
			@param target URL containing the final location of the file.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be cached
		               only for a short duration after which the user will again be
		               prompted for passwords as needed.
				@return true if successful, false for failure
     
		@short    Uploads file <code>src</code> to URL <code>target.</code>
	*/
	public static native boolean upload(String src, KURL target, QWidget window);
	/**	
		 Alternative to upload for copying over the network.
		 Overwrite is false, so this will fail if <code>target</code> exists.
			 This one takes two URLs and is a direct equivalent
		 of KIO.file_copy (not KIO.copy!).
		 It will be renamed file_copy in KDE4, so better use file_copy.
			@param src URL Referencing the file to upload.
			@param target URL containing the final location of the file.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be cached
		               only for a short duration after which the user will again be
		               prompted for passwords as needed.
				@return true if successful, false for failure
     
		@short    Alternative to upload for copying over the network.
	*/
	public static native boolean copy(KURL src, KURL target, QWidget window);
	/**	
		 Full-fledged equivalent of KIO.file_copy
		     		@short    Full-fledged equivalent of KIO.file_copy
	*/
	public static native boolean file_copy(KURL src, KURL dest, int permissions, boolean overwrite, boolean resume, QWidget window);
	public static native boolean file_copy(KURL src, KURL dest, int permissions, boolean overwrite, boolean resume);
	public static native boolean file_copy(KURL src, KURL dest, int permissions, boolean overwrite);
	public static native boolean file_copy(KURL src, KURL dest, int permissions);
	public static native boolean file_copy(KURL src, KURL dest);
	/**	
		 Full-fledged equivalent of KIO.file_move.
		 Moves or renames one file.
				@short    Full-fledged equivalent of KIO.file_move.
	*/
	public static native boolean file_move(KURL src, KURL target, int permissions, boolean overwrite, boolean resume, QWidget window);
	public static native boolean file_move(KURL src, KURL target, int permissions, boolean overwrite, boolean resume);
	public static native boolean file_move(KURL src, KURL target, int permissions, boolean overwrite);
	public static native boolean file_move(KURL src, KURL target, int permissions);
	public static native boolean file_move(KURL src, KURL target);
	/**	
		 Alternative method for copying over the network.
		 Overwrite is false, so this will fail if <code>target</code> exists.
			 This one takes two URLs and is a direct equivalent
		 of KIO.copy!.
		 This means that it can copy files and directories alike
		 (it should have been named copy()).
			@param src URL Referencing the file to upload.
			@param target URL containing the final location of the
		               file.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be cached
		               only for a short duration after which the user will again be
		               prompted for passwords as needed.
				@return true if successful, false for failure
     
		@short    Alternative method for copying over the network.
	*/
	public static native boolean dircopy(KURL src, KURL target, QWidget window);
	/**	
		 Overloaded method, which takes a list of source urls
		     		@short    Overloaded method, which takes a list of source urls
	*/
	public static native boolean dircopy(ArrayList src, KURL target, QWidget window);
	public static native boolean dircopy(ArrayList src, KURL target);
	/**	
		 Full-fledged equivalent of KIO.move.
		 Moves or renames one file or directory.
				@short    Full-fledged equivalent of KIO.move.
	*/
	public static native boolean move(KURL src, KURL target, QWidget window);
	public static native boolean move(KURL src, KURL target);
	/**	
		 Full-fledged equivalent of KIO.move.
		 Moves or renames a list of files or directories.
				@short    Full-fledged equivalent of KIO.move.
	*/
	public static native boolean move(ArrayList src, KURL target, QWidget window);
	public static native boolean move(ArrayList src, KURL target);
	/**	
		 Tests whether a URL exists.
			@param url the url we are testing
			@param source if true, we want to read from that URL.
		               If false, we want to write to it.
		 IMPORTANT: see documentation for KIO.stat for more details about this.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be
		               cached only for a short duration after which the user will
		               again be prompted for passwords as needed.
				@return true if the URL exists and we can do the operation specified by
              <code>source</code>, false otherwise
     
		@short    Tests whether a URL exists.
	*/
	public static native boolean exists(KURL url, boolean source, QWidget window);
	/**	
		 Tests whether a URL exists and return information on it.
			 This is a convenience function for KIO.stat
		 (it saves creating a slot and testing for the job result).
			@param url The URL we are testing.
			@param entry The result of the stat. Iterate over the list
		 of atoms to get hold of name, type, size, etc., or use KFileItem.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be
		               cached only for a short duration after which the user will
		               again be prompted for passwords as needed.
				@return true if successful, false for failure
     
		@short    Tests whether a URL exists and return information on it.
	*/
	// bool stat(const KURL& arg1,KIO::UDSEntry& arg2,QWidget* arg3); >>>> NOT CONVERTED
	/**	
		 Deletes a file or a directory in an synchronous way.
			 This is a convenience function for KIO.del
		 (it saves creating a slot and testing for the job result).
			@param url The file or directory to delete.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be
		               cached only for a short duration after which the user will
		               again be prompted for passwords as needed.
				@return true on success, false on failure.
     
		@short    Deletes a file or a directory in an synchronous way.
	*/
	public static native boolean del(KURL url, QWidget window);
	/**	
		 Creates a directory in a synchronous way.
			 This is a convenience function for <code>KIO</code>.mkdir
		 (it saves creating a slot and testing for the job result).
			@param url The directory to create.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be
		               cached only for a short duration after which the user will
		               again be prompted for passwords as needed.
				@return true on success, false on failure.
     
		@short    Creates a directory in a synchronous way.
	*/
	public static native boolean mkdir(KURL url, QWidget window, int permissions);
	public static native boolean mkdir(KURL url, QWidget window);
	/**	
		 Executes a remote process via the fish ioslave in a synchrounous way.
			@param url The remote machine where the command should be executed.
		            e.g. fish://someuser\@somehost:sshport/
		            some special cases exist.
		            fish://someuser\@localhost/
		            will use su instead of ssh to connect and execute the command.
		            fish://someuser\@localhost:port/
		            will use ssh to connect and execute the command.
			@param command The command to be executed.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be
		               cached only for a short duration after which the user will
		               again be prompted for passwords as needed.
				@return The resulting output of the <code>command</code> that is executed.
     
		@short    Executes a remote process via the fish ioslave in a synchrounous way.
	*/
	public static native String fish_execute(KURL url, String command, QWidget window);
	/**	
			 This function is not implemented!?
		 (only mimetypeInternal)
			 Determines the mimetype of a given URL.
			 This is a convenience function for KIO.mimetype.  You
		 should call this only when really necessary. 
		 KMimeType.findByURL can determine extension a lot faster, but
		 less reliably for remote files. Only when findByURL() returns
		 unknown (application/octet-stream) then this one should be
		 used.
			@param url The URL whose mimetype we are interested in.
			@param window main window associated with this job. This is used to
		               automatically cache and discard authentication information
		               as needed. If NULL, authentication information will be
		               cached only for a short duration after which the user will
		               again be prompted for passwords as needed.
				@return The mimetype name.
     
		@short
	*/
	public static native String mimetype(KURL url, QWidget window);
	/**	
		 Returns the error string for the last job, in case it failed.
				@return the last error string, or null
     
		@short    Returns the error string for the last job, in case it failed.
	*/
	public static native String lastErrorString();
}
