/***************************************************************************
                            CSSStyleDeclaration.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef CSSSTYLEDECLARATION_H
#define CSSSTYLEDECLARATION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The <code> CSSStyleDeclaration </code> interface represents a
 single <a href="http://www.w3.org/TR/REC-CSS2/syndata.-[html block]">
 CSS declaration block </a> . This interface may be used to
 determine the style properties currently set in a block or to set
 style properties explicitly within the block.

  While an implementation may not recognize all CSS properties
 within a CSS declaration block, it is expected to provide access to
 all specified properties through the <code> CSSStyleDeclaration
 </code> interface. Furthermore, implementations that support a
 specific level of CSS should correctly handle <a
 href="http://www.w3.org/TR/REC-CSS2/about.-[html shorthand]"> CSS
 shorthand </a> properties for that level. For a further discussion
 of shorthand properties, see the <code> CSS2Properties </code>
 interface.

 
 @short 
 The <code> CSSStyleDeclaration </code> interface represents a
 single <a href="http://www.
*/
@class CSSValue;


@interface  CSSStyleDeclaration : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 
 The parsable textual representation of the declaration block
 (including the surrounding curly braces). Setting this
 attribute will result in the parsing of the new value and
 resetting of the properties in the declaration block.

     
*/
- (NSString *) cssText;

/** 
 see @ref cssText

     
*/
- setCssText: (NSString *)arg1;

/** 
 The number of properties that have been explicitly set in this
 declaration block.

     
*/
- (unsigned long) length;

/** 
 The CSS rule that contains this declaration block.

     
*/
//- (CSSRule*) parentRule;

/** 
 Used to retrieve the value of a CSS property if it has been
 explicitly set within this declaration block.

     
*/
- (NSString *) getPropertyValue: (NSString *)propertyName;

/** 
 Used to retrieve the object representation of the value of a
 CSS property if it has been explicitly set within this
 declaration block. This method returns null if the property is
 a <a href="http://www.w3.org/TR/REC-CSS2/about.-[html shorthand]">
 shorthand </a> property. Shorthand property values can only be
 accessed and modified as strings, using the <code>
 getPropertyValue </code> and <code> setProperty </code>
 methods.

     
*/
- (CSSValue*) getPropertyCSSValue: (NSString *)propertyName;

/** 
 Used to remove a CSS property if it has been explicitly set
 within this declaration block.

     
*/
- (NSString *) removeProperty: (NSString *)propertyName;

/** 
 Used to retrieve the priority of a CSS property (e.g. the
 <code> "important" </code> qualifier) if the property has been
 explicitly set in this declaration block.

     
*/
- (NSString *) getPropertyPriority: (NSString *)propertyName;

/** 
 Used to set a property value and priority within this
 declaration block.

     
*/
- setProperty: (NSString *)propertyName value: (NSString *)value priority: (NSString *)priority;

/** 
 Used to retrieve the properties that have been explicitly set
 in this declaration block. The order of the properties
 retrieved using this method does not have to be the order in
 which they were set. This method can be used to iterate over
 all properties in this declaration block.

     
*/
- (NSString *) item: (unsigned long)index;
- (BOOL) isNull;
@end

#endif
