/***************************************************************************
                            KAccel.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KACCEL_H
#define KACCEL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QAccel.h>

/**

 Handle shortcuts.

 Allow a user to configure shortcuts
 through application configuration files or through the
 @ref KKeyChooser GUI.

 A @ref KAccel contains a list of @ref KAccelAction objects.

 For example, CTRL+Key_P could be a shortcut for printing a document. The key
 codes are listed in qnamespace.h. "Print" could be the action name for printing.
 The action name identifies the shortcut in configuration files and the
 @ref KKeyChooser GUI.

 A KAccel object handles key events sent to its parent widget and to all
 children of this parent widget.  The most recently created KAccel object
 has precedence over any KAccel objects created before it.
 When a shortcut pressed, KAccel calls the slot to which it has been
 connected.

 Reconfiguration of a given shortcut can be prevented by specifying
 that an accelerator item is not configurable when it is inserted. A special
 group of non-configurable key bindings are known as the
 standard accelerators.

 The standard accelerators appear repeatedly in applications for
 standard document actions such as printing and saving. A convenience method is
 available to insert and connect these accelerators which are configurable on
 a desktop-wide basis.

 It is possible for a user to choose to have no key associated with
 an action.

 The translated first argument for @ref -insertItem is used only
 in the configuration dialog.
<pre>
 KAccel* pAccel = new KAccel( this );

 // Insert an action "Scroll Up" which is associated with the "Up" key:
 -[pAccel insert]( "Scroll Up", i18n("Scroll up"),
                       i18n("Scroll up the current document by one line."),
                       -[Qt Key_Up], this, SLOT(-slotScrollUp) );
 // Insert an standard acclerator action.
 -[pAccel insert]( -[KStdAccel Print], this, SLOT(-slotPrint) );

 // Update the shortcuts by read any user-defined settings from the
 //  application's config file.
 -[pAccel readSettings];
</pre>

 @version $Id: KAccel.h,v 1.4 2002/04/15 21:17:11 rdale Exp $
 
 @short Configurable shortcut support.

*/
@class KConfigBase;
@class KShortcut; 
@class QPopupMenu; 

@interface KAccel : QAccel 
- initWithWidget: (QWidget *)pParent psName: (NSString *)psName;
- initWithWidget: (QWidget *)pParent ;
- initWithWidget: (QWidget *)watch parent: (QObject *)parent psName: (NSString *)psName;
- initWithWidget: (QWidget *)watch parent: (QObject *)parent ;
- (void) dealloc;
//- (KAccelActions*) actions;
//- (KAccelActions*) actions;
- (BOOL) isEnabled;
- setEnabled: (BOOL)bEnabled;
- (BOOL) getAutoUpdate;
- (BOOL) setAutoUpdate: (BOOL)bAuto;

/** 
 Create an accelerator action.

 Usage:
<pre>
 insert( "Do Something", i18n("Do Something"),
   i18n("This action allows you to do something really great with this program to "
        "the currently open document."),
   ALT+Key_D, this, SLOT(-slotDoSomething) );
</pre>

*/
//- (KAccelAction*) insert: (NSString *)sAction sLabel: (NSString *)sLabel sWhatsThis: (NSString *)sWhatsThis cutDef: (KShortcut*)cutDef pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot bConfigurable: (BOOL)bConfigurable bEnabled: (BOOL)bEnabled;
//- (KAccelAction*) insert: (NSString *)sAction sLabel: (NSString *)sLabel sWhatsThis: (NSString *)sWhatsThis cutDef: (KShortcut*)cutDef pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot ;

/** 
 Same as first -insert, but with separate shortcuts defined for
 3- and 4- modifier defaults.
	 
*/
//- (KAccelAction*) insert: (NSString *)sAction sLabel: (NSString *)sLabel sWhatsThis: (NSString *)sWhatsThis cutDef3: (KShortcut*)cutDef3 cutDef4: (KShortcut*)cutDef4 pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot bConfigurable: (BOOL)bConfigurable bEnabled: (BOOL)bEnabled;
//- (KAccelAction*) insert: (NSString *)sAction sLabel: (NSString *)sLabel sWhatsThis: (NSString *)sWhatsThis cutDef3: (KShortcut*)cutDef3 cutDef4: (KShortcut*)cutDef4 pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot ;

/** 
 This is an overloaded function provided for convenience.
 The advantage of this is when you want to use the same text for the name
 of the action as for the user-visible label.

 Usage: insert( I18N_NOOP("Do Something"), ALT+Key_D, this, SLOT(-slotDoSomething) );

*/
//- (KAccelAction*) insert: (NSString *)psAction cutDef: (KShortcut*)cutDef pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot bConfigurable: (BOOL)bConfigurable bEnabled: (BOOL)bEnabled;
//- (KAccelAction*) insert: (NSString *)psAction cutDef: (KShortcut*)cutDef pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot ;

/** 
 Similar to the first -insert method, but with the action
 name, short description, help text, and default shortcuts all
 set according to one of the standard accelerators.

*/
//- (KAccelAction*) insert: (int)identifier pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot bConfigurable: (BOOL)bConfigurable bEnabled: (BOOL)bEnabled;
//- (KAccelAction*) insert: (int)identifier pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot ;

/** 
 Use this to insert a label into the action list.  This will be
 displayed when the user configures shortcuts.
	 
*/
//- (KAccelAction*) insert: (NSString *)sName sLabel: (NSString *)sLabel;
- (BOOL) remove: (NSString *)sAction;
- (BOOL) updateConnections;

/**  Return the shortcut associated with the action named by @p sAction. 
*/
- (KShortcut*) shortcut: (NSString *)sAction;

/**  Set the shortcut to be associated with the action named by @p sAction. 
*/
- (BOOL) setShortcut: (NSString *)sAction shortcut: (KShortcut*)arg1;

/**  Set the slot to be called when the shortcut of the action named
 by @p sAction is pressed. 
*/
- (BOOL) setSlot: (NSString *)sAction pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot;

/**  Enable or disable the action named by @p sAction. 
*/
- (BOOL) setEnabled: (NSString *)sAction bEnabled: (BOOL)bEnabled;

/** 
 Read all shortcuts from @p pConfig, or (if @p pConfig
 is zero) from the application's configuration file
 @ref -[KGlobal config].

 The group in which the configuration is stored can be
 set with @ref -setConfigGroup.
	 
*/
- (BOOL) readSettings: (KConfigBase*)pConfig;
- (BOOL) readSettings;

/** 
 Write the current shortcuts to @p pConfig,
 or (if @p pConfig is zero) to the application's
 configuration file.
	 
*/
- (BOOL) writeSettings: (KConfigBase*)pConfig;
- (BOOL) writeSettings;
- setConfigGroup: (NSString *)arg1;
- emitKeycodeChanged;
- (BOOL) insertTextItem: (NSString *)sLabel sAction: (NSString *)sAction psKey: (NSString *)psKey nIDMenu: (int)nIDMenu pMenu: (QPopupMenu*)pMenu bConfigurable: (BOOL)bConfigurable;
- (BOOL) insertTextItem: (NSString *)sLabel sAction: (NSString *)sAction psKey: (NSString *)psKey ;
- (BOOL) insertTextItem: (NSString *)sLabel sAction: (NSString *)sAction key: (int)key nIDMenu: (int)nIDMenu pMenu: (QPopupMenu*)pMenu bConfigurable: (BOOL)bConfigurable;
- (BOOL) insertTextItem: (NSString *)sLabel sAction: (NSString *)sAction key: (int)key ;
- (BOOL) insertStdItem: (int)identifier descr: (NSString *)descr;
- (BOOL) insertStdItem: (int)identifier ;
- (BOOL) connectItem: (NSString *)sAction pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot bActivate: (BOOL)bActivate;
- (BOOL) connectItem: (NSString *)sAction pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot ;
- (BOOL) connectItemId: (int)accel pObjSlot: (QObject *)pObjSlot psMethodSlot: (NSString *)psMethodSlot;
- (BOOL) removeTextItem: (NSString *)sAction;
- (BOOL) setItemEnabled: (NSString *)sAction bEnable: (BOOL)bEnable;
- changeMenuAccel: (QPopupMenu*)menu identifier: (int)identifier action: (NSString *)action;
- changeMenuAccel: (QPopupMenu*)menu identifier: (int)identifier accel: (int)accel;

/** 
 @depricated.  Use -shortcut.
 Retrieve the key code of the accelerator item with the action name
 @p action, or zero if either the action name cannot be
 found or the current key is set to no key.
	 
*/
- (int) currentKey: (NSString *)action;

/** 
 @depricated.  Use -actions.-actionPtr.
 Return the name of the accelerator item with the keycode @p key,
 or @ref -[QString null]if the item cannot be found.
	 
*/
- (NSString *) findKey: (int)key;
+ (int) stringToKey: (NSString *)arg1;
@end

/** Override these methods in subclasses of KAccel to customise event handling behaviour */
@protocol KAccelEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
