/***************************************************************************
                            KColorDrag.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOLORDRAG_H
#define KCOLORDRAG_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QStoredDrag.h>

/**

 A drag-and-drop object for colors. The according MIME type
 is set to application/x-color.

 See the Qt drag'n'drop documentation.
 
 @short 
 A drag-and-drop object for colors.
*/
@interface KColorDrag : QStoredDrag 

/** 
 Constructs a color drag with a white color.
     
*/
- initWithWidget: (QWidget *)dragsource name: (NSString *)name;
- init;

/** 
 Constructs a color drag with the color @p.
     
*/
- initWithColor: (QColor *)col dragsource: (QWidget *)dragsource name: (NSString *)name;
- initWithColor: (QColor *)col ;
- (void) dealloc;

/** 
 Sets the color of the drag to @p col.
     
*/
- setColor: (QColor *)col;

/** 
 Returns true if the MIME source @p e contains a color object.
     
*/
+ (BOOL) canDecode: (QMimeSource*)e;

/** 
 Decodes the MIME source @p e and puts the resulting color into @p col.
     
*/
+ (BOOL) decode: (QMimeSource*)e col: (QColor *)col;

/** 

     
*/
+ (KColorDrag*) makeDrag: (QColor *)arg1 dragsource: (QWidget *)dragsource;
@end

/** Override these methods in subclasses of KColorDrag to customise event handling behaviour */
@protocol KColorDragEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
