/***************************************************************************
                            KEdit.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KEDIT_H
#define KEDIT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QMultiLineEdit.h>

/**

 A simple text editor for the KDE project.

 @author Bernd Johannes Wuebben <wuebben@math.cornell.edu>, Waldo Bastian <bastian@kde.org>

 @short 
 A simple text editor for the KDE project.
*/
@class QTextStream; 
@class parse; 

@interface KEdit : QMultiLineEdit 

/** 
 The usual constructor.

*/
- initWithWidget: (QWidget *)_parent name: (NSString *)name;
- init;
- (void) dealloc;

/** 
 Insert text from the text stream into the edit widget.

*/
- insertText: (QTextStream*)arg1;

/** 
 Save text from the edit widget to a text stream.

*/
- saveText: (QTextStream*)arg1;

/** 
  Let the user select a font and set the font of the textwidget to that
 selected font.

*/
- selectFont;

/** 
 Present a search dialog to the user

*/
- search;

/** 
 Repeat the last search specified on the search dialog.

  If the user hasn't searched for anything until now, this method
   will simply return without doing anything.

*/
- (BOOL) repeatSearch;

/** 
 Present a Search and Replace Dialog to the user.

*/
- replace;

/** 
 Present a "Goto Line" dialog to the user.
     
*/
- doGotoLine;

/** 
 Clean up redundant whitespace from selected text.
     
*/
- cleanWhiteSpace;

/** 
 Install a context menu for KEdit.

  The Popup Menu will be activated on a right mouse button press event.
     
*/
- installRBPopup: (QPopupMenu*)arg1;

/** 
 Retrieve the current line number.

 The current line is the line the cursor is on.

*/
- (int) currentLine;

/** 
 Retrieve the actual column number the cursor is on.

  This call differs
    from @ref -[QMultiLineEdit getCursorPosition] in that it returns the actual cursor
    position and not the character position. Use @ref -currentLine and @ref -currentColumn
    if you want to display the current line or column in the status bar for
    example.
     
*/
- (int) currentColumn;

/** 
 Start spellchecking mode.
     
*/
- spellcheck_start;

/** 
 Exit spellchecking mode.
     
*/
- spellcheck_stop;

/** 
 Allow the user to toggle between insert mode and overwrite mode with
 the "Insert" key. See also @ref -toggle_overwrite_signal;

 The default is false: the user can not toggle.
     
*/
- setOverwriteEnabled: (BOOL)b;
- computePosition;
- (int) doSearch: (NSString *)s_pattern case_sensitive: (BOOL)case_sensitive regex: (BOOL)regex forward: (BOOL)forward line: (int)line col: (int)col;
- (int) doReplace: (NSString *)s_pattern case_sensitive: (BOOL)case_sensitive regex: (BOOL)regex forward: (BOOL)forward line: (int)line col: (int)col replace: (BOOL)replace;

/** 
 Sets line and col to the position pos, considering word wrap.

*/
- posToRowCol: (unsigned int)pos line: (unsigned int)line col: (unsigned int)col;

/** 
 Reimplemented for internal reasons, the API is not affected.
     
*/
- create: (unsigned int)arg1 initializeWindow: (BOOL)initializeWindow destroyOldWindow: (BOOL)destroyOldWindow;
- create;
+ (int) NONE;
+ (int) FORWARD;
+ (int) BACKWARD;
@end

/** Override these methods in subclasses of KEdit to customise event handling behaviour */
@protocol KEditEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) e;
- contentsWheelEvent:(QWheelEvent*) e;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) e;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) e;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) e;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) e;
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) e;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) e;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) e;
- contentsMouseMoveEvent:(QMouseEvent*) e;
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- viewportPaintEvent:(QPaintEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) e;
@end


#endif
