/***************************************************************************
                            KFilePropsPlugin.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEPROPSPLUGIN_H
#define KFILEPROPSPLUGIN_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KPropsDlgPlugin.h>

/**

 'General' plugin
  This plugin displays the name of the file, its size and access times.

 
 @short 
 'General' plugin
  This plugin displays the name of the file, its size and access times.
*/
@class Job; 
@class KPropertiesDialog;
@class KURL;

@interface KFilePropsPlugin : KPropsDlgPlugin 

/** 
 Constructor
   
*/
- initWithPropertiesDialog: (KPropertiesDialog*)_props;
- (void) dealloc;

/** 
 Applies all changes made.  This plugin must be always the first
 plugin in the dialog, since this function may rename the file which
 may confuse other applyChanges functions.
   
*/
- applyChanges;

/** 
 Called after all plugins applied their changes
   
*/
- postApplyChanges;

/** 
 Tests whether the files specified by _items need a 'General' plugin.
   
*/
+ (BOOL) supports: (NSArray *)_items;
- slotCopyFinished: (Job*)arg1;
- slotFileRenamed: (Job*)arg1 url: (KURL*)arg2 url: (KURL*)arg3;
- slotDirSizeFinished: (Job*)arg1;
- slotFoundMountPoint: (NSString *)mp kBSize: (unsigned long)kBSize kBUsed: (unsigned long)kBUsed kBAvail: (unsigned long)kBAvail;
- slotSizeStop;
- slotSizeDetermine;
@end

/** Override these methods in subclasses of KFilePropsPlugin to customise event handling behaviour */
@protocol KFilePropsPluginEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
