/***************************************************************************
                            KFilterBase.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILTERBASE_H
#define KFILTERBASE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 This is the base class for compression filters
 such as gzip and bzip2. It's pretty much internal.
 Don't use directly, use KFilterDev instead.
 
 @short 
 This is the base class for compression filters
 such as gzip and bzip2.
*/
@class QIODevice; 

@interface KFilterBase : QObject 
- (void) dealloc;

/** 
 Sets the device on which the filter will work
 If @p autodelete is set to true, @p dev is deleted when the filter is deleted
     
*/
- setDevice: (QIODevice *)dev autodelete: (BOOL)autodelete;
- setDevice: (QIODevice *)dev ;
- (QIODevice*) device;
- init: (int)mode;
- (int) mode;
- terminate;
- reset;
- (BOOL) readHeader;
- (BOOL) writeHeader: (NSString *)filename;
- setOutBuffer: (NSString *)data maxlen: (unsigned int)maxlen;
- setInBuffer: (NSString *)data size: (unsigned int)size;
- (BOOL) inBufferEmpty;
- (int) inBufferAvailable;
- (BOOL) outBufferFull;
- (int) outBufferAvailable;
- (int) uncompress;
- (int) compress: (BOOL)finish;

/** 
 Call this to create the appropriate filter for the file
 named @p fileName.
     
*/
+ (KFilterBase*) findFilterByFileName: (NSString *)fileName;

/** 
 Call this to create the appropriate filter for the mimetype
 @p mimeType. For instance application/x-gzip.
     
*/
+ (KFilterBase*) findFilterByMimeType: (NSString *)mimeType;
+ (int) OK;
+ (int) END;
+ (int) ERROR;
@end

/** Override these methods in subclasses of KFilterBase to customise event handling behaviour */
@protocol KFilterBaseEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
