/***************************************************************************
                            KGlobal.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KGLOBAL_H
#define KGLOBAL_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Access to the KDE global objects.

 @author Sirtaj Singh Kang (taj@kde.org)

 @version $Id: KGlobal.h,v 1.3 2002/03/15 02:12:20 rdale Exp $
 
 @short 
 Access to the KDE global objects.
*/
@class KCharsets; 
@class KConfig; 
@class KIconLoader; 
@class KInstance; 
@class KLocale; 
@class KStandardDirs; 
@class KStaticDeleterBase; 

@interface  KGlobal : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 Returns the global instance.  There is always at least
 one instance of a component in one application (in most
 cases the application itself).
     
*/
+ (KInstance*) instance;

/** 
  Returns the application standard dirs object.
     
*/
+ (KStandardDirs*) dirs;

/** 
  Returns the general config object.
     
*/
+ (KConfig*) config;

/** 
  Returns an iconloader object.
     
*/
+ (KIconLoader*) iconLoader;
+ (KLocale*) locale;
+ (KCharsets*) charsets;

/** 
 Creates a static QString.

 To be used inside functions(!) like:
 static const QString &myString = -[KGlobal staticQString]("myText");

 !!! Do _NOT_ use: !!!
 static QString myString = -[KGlobal staticQString]("myText");
 This creates a static object (instead of a static reference)
 and as you know static objects are EVIL.
     
*/
+ (NSString *) staticQString: (NSString *)arg1;

/** 
 Creates a static QString.

 To be used inside functions(!) like:
 static const QString &myString = -[KGlobal staticQString](i18n("My Text"));

 !!! Do _NOT_ use: !!!
 static QString myString = -[KGlobal staticQString](i18n("myText"));
 This creates a static object (instead of a static reference)
 and as you know static objects are EVIL.
     
*/
+ (NSString *) staticQString: (NSString *)arg1;
+ registerStaticDeleter: (KStaticDeleterBase*)arg1;
+ unregisterStaticDeleter: (KStaticDeleterBase*)arg1;
+ deleteStaticDeleters;

/** 
 The instance currently active (useful in a multi-instance
 application, such as a KParts application).
 Don't use this - it's mainly for KAboutDialog and KBugReport.
     
*/
+ setActiveInstance: (KInstance*)d;
+ (KInstance*) activeInstance;
@end

#endif
