/***************************************************************************
                            KMimeType.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KMIMETYPE_H
#define KMIMETYPE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KServiceType.h>

/**

 Represent a mime type, like "text/plain".

 The starting point you need is often the static methods.
 See also @ref KServiceType.
 
 @short 
 Represent a mime type, like "text/plain".
*/
@class KDesktopFile; 
@class KURL; 
@class List; 
@class QDataStream; 
@class QPixmap; 
@class QVariant; 

@class QByteArray; 

@interface KMimeType : KServiceType 

/** 
 Constructor.

 You may pass in arguments to create a mimetype with
 specific properties.
   
*/
- initWithText: (NSString *)_fullpath _type: (NSString *)_type _icon: (NSString *)_icon _comment: (NSString *)_comment _patterns: (NSArray *)_patterns;

/** 
 Construct a mimetype and take all information from a config file.
   
*/
- initWithText: (NSString *)_fullpath;

/** 
 Construct a mimetype and take all information from a desktop file.
   
*/
- initWithDesktopFile: (KDesktopFile*)config;

/** 

 The stream must already be positionned at the correct offset
   
*/
- initWithDataStream: (QDataStream *)_str offset: (int)offset;
- (void) dealloc;

/** 
 Return the filename of the icon associated with the mimetype.

 The arguments are unused, but provided so that KMimeType-derived classes
 can use them (e.g. @ref KFolderType uses the URL to return one out of 2 icons)

*/
- (NSString *) icon: (NSString *)arg1 bool: (BOOL)arg2;

/** 
 This function differs from the above only in that a @ref KURL may be
 provided instead of a @ref QString for convenience.
   
*/
- (NSString *) iconForURL: (KURL*)arg1 bool: (BOOL)arg2;

/** 
 Use this function only if you don't have a special URL
 for which you search a pixmap.

 This function is useful to find
 out, which icon is usually chosen for a certain mime type. Since
 no URL is passed, it is impossible to obey icon hints in desktop
 entries for example.

*/
- (QPixmap*) pixmap: (int)_group _force_size: (int)_force_size _state: (int)_state _path: (NSString *)_path;
- (QPixmap*) pixmap: (int)_group ;

/** 
 Find the pixmap for a given file of this mimetype.

 Convenience method that uses @ref -icon, but also locates and
 load the pixmap.

*/
- (QPixmap*) pixmap: (KURL*)_url _group: (int)_group _force_size: (int)_force_size _state: (int)_state _path: (NSString *)_path;
- (QPixmap*) pixmap: (KURL*)_url _group: (int)_group ;

/** 

*/
- (NSString *) comment;

/** 
 The arguments are unused, but provided so that KMimeType derived classes
 can use them.

*/
- (NSString *) comment: (NSString *)arg1 bool: (BOOL)arg2;

/** 
 This function differs from the above only in that a @ref KURL may be
 provided instead of a @ref QString for convenience.
   
*/
- (NSString *) commentForURL: (KURL*)arg1 bool: (BOOL)arg2;

/** 
 Retrieve the list of patterns associated with the MIME Type.
   
*/
- (NSArray *) patterns;

/** 
 Load the mimetype from a stream.
   
*/
- load: (QDataStream *)arg1;

/** 
 Save the mimetype to a stream.
   
*/
- save: (QDataStream *)arg1;
- (QVariant*) property: (NSString *)_name;
- (NSArray *) propertyNames;

/** 
 Convenience method to find the pixmap for a URL

 Call this one when you don't know the mimetype.

*/
+ (QPixmap*) pixmapForURL: (KURL*)_url _mode: (long)_mode _group: (int)_group _force_size: (int)_force_size _state: (int)_state _path: (NSString *)_path;
+ (QPixmap*) pixmapForURL: (KURL*)_url ;

/** 
 The same functionality as pixmapForURL, but this method returns the name
 of the icon to load. You'll have to use KIconLoader to load the pixmap for it.
 The advantage of this method is that you can store the result, and then use it
 later on for any kind of size.
   
*/
+ (NSString *) iconForURL: (KURL*)_url _mode: (long)_mode;

/** 

 If unavailable, returns -[QString null].
   
*/
+ (NSString *) favIconForURL: (KURL*)url;

/** 
 Retrieve a pointer to the mime type @p _name or a pointer to the default
         mime type "application/octet-stream".

 0L is @em never returned.

 @em Very @em important: Don't store the result in a KMimeType* !

*/
+ (void*) mimeType: (NSString *)_name;

/** 
 This function looks at mode_t first.

 If that does not help it
 looks at the extension.  This is fine for FTP, FILE, TAR and
 friends, but is not for HTTP ( cgi scripts! ). You should use
 @ref KRun instead, but this function returns immediately while
 @ref KRun is async. If no extension matches, then
 @ref KMimeMagic is used if the URL a local file or
 "application/octet-stream" is returned otherwise.

*/
+ (void*) findByURL: (KURL*)_url _mode: (long)_mode _is_local_file: (BOOL)_is_local_file _fast_mode: (BOOL)_fast_mode;
+ (void*) findByURL: (KURL*)_url ;

/** 
 Same as findByURL but for local files only - convenience method.

 Equivalent to KURL u; u.setPath(path); return findByURL( u, mode, true, fast_mode );
   
*/
+ (void*) findByPath: (NSString *)path mode: (long)mode fast_mode: (BOOL)fast_mode;
+ (void*) findByPath: (NSString *)path ;

/** 
 Tries to find out the MIME type of a data chunk by looking for
 certain magic numbers and characteristic strings in it.
 Returns application/octet-stream of the type can not be found
 this way.
 If accuracy is not a null pointer, *accuracy is set to the
 accuracy of the match (which is in the range 0..100).
   
*/
+ (void*) findByContent: (QByteArray*)data accuracy: (int*)accuracy;
+ (void*) findByContent: (QByteArray*)data ;

/** 
 Tries to find out the MIME type of a file by looking for
 certain magic numbers and characteristic strings in it.
 This function is similar to the previous one. Note that the
 file name is not used for determining the file type, it is just
 used for loading the file's contents.
 If accuracy is not a null pointer, *accuracy is set to the
 accuracy of the match (which is in the range 0..100).
   
*/
+ (void*) findByFileContent: (NSString *)fileName accuracy: (int*)accuracy;
+ (void*) findByFileContent: (NSString *)fileName ;

/** 
 Get all the mimetypes.

 Useful for showing the list of
 available mimetypes.
 More memory consuming than the ones above, don't use unless
 really necessary.
   
*/
//+ (List) allMimeTypes;

/** 

*/
+ (NSString *) defaultMimeType;
- loadInternal: (QDataStream *)arg1;
- init: (KDesktopFile*)arg1;

/** 
 Signal a missing mime type
   
*/
//+ errorMissingMimeType: (NSString *)_type;

/** 
 This function makes sure that the default mime type exists.
   
*/
//+ buildDefaultType;

/** 
 This function makes sure that vital mime types are installed.
   
*/
//+ checkEssentialMimeTypes;
@end

#endif
