/***************************************************************************
                            KNotifyClient.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KNOTIFYCLIENT_H
#define KNOTIFYCLIENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 This namespace provides a method for issuing events to a KNotifyServer
 call -[KNotifyClient event]("eventname"); to issue it.
 On installation, there should be a file called
 $KDEDIR/share/apps/appname/eventsrc which contains the events.

 The file looks like this:
 <pre>
 [!Global!]
 IconName=Filename (e.g. kdesktop, without any extension)
 Comment=FriendlyNameOfApp

 [eventname]
 Name=FriendlyNameOfEvent
 Comment=Description Of Event
 default_sound=filetoplay.wav
 default_presentation=1
  ...
 </pre>
 default_presentation contains these ORed events:
	None=0, Sound=1, Messagebox=2, Logfile=4, Stderr=8

 You can also use the "nopresentation" key, with any the presentations
 ORed.  Those that are in that field will not appear in the kcontrol
 module.  This was intended for software like KWin to not allow a window-opening
 that opens a window (e.g., allowing to disable KMessageBoxes from appearing)
 If the user edits the eventsrc file manually, it will appear.  This only
 affects the KcmNotify.

 You can also use the following events, which are system controlled
 and do not need to be placed in your eventsrc:

<ul>
 <li>cannotopenfile
 <li>notification
 <li>warning
 <li>fatalerror
 <li>catastrophe
</ul>

 @author Charles Samuels <charles@kde.org>
 
 @short 
 This namespace provides a method for issuing events to a KNotifyServer
 call KNotifyClient::event("eventname"); to issue it.
*/
@class KInstance; 

@interface  KNotifyClient : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 This starts the KNotify Daemon, if it's not already started.
 This will be useful for games that use sound effects. Run this
 at the start of the program, and there won't be a pause when it is
 first triggered.

*/
- (BOOL) startDaemon;

/** 
 This should be the most used method in here.
 Call it by -[KNotifyClient event]("EventName");
 It will use -[KApplication kApplication]->-dcopClient to communicate to
 the server

*/
//- (BOOL) event: (NSString *)message text: (NSString *)text;
//- (BOOL) event: (NSString *)message ;

/** 
 Allows to easily emit standard events.

*/
//- (BOOL) eventType: (int)event text: (NSString *)text;
//- (BOOL) eventType: (int)event ;

/** 
 Will fire an event that's not registered.

*/
//- (BOOL) userEvent: (NSString *)text present: (int)present level: (int)level sound: (NSString *)sound file: (NSString *)file;
//- (BOOL) userEvent;

/** 
 This is a simple substitution for -[QApplication beep].
 It simply calls
 <pre>
 -[KNotifyClient event]( -[KNotifyClient notification], reason );
 </pre>
	 
*/
//- beep: (NSString *)reason;
//- beep;

/** 
 Gets the presentation associated with a certain event name
 Remeber that they may be ORed:
 if (present & -[KNotifyClient Sound]) { [Yes, sound is a default] }	
	 
*/
//- (int) getPresentation: (NSString *)eventname;

/** 
 Gets the default file associated with a certain event name
 The control panel module will list all the event names
 This has the potential for being slow.
	 
*/
//- (NSString *) getFile: (NSString *)eventname present: (int)present;

/** 
 Gets the default presentation for the event of this program.
 Remember that the Presentation may be ORed.  Try this:
 if (present & -[KNotifyClient Sound]) { [Yes, sound is a default] }
	 
*/
//- (int) getDefaultPresentation: (NSString *)eventname;

/** 
 Gets the default File for the event of this program.
 It gets it in relation to present.
 Some events don't apply to this function ("Message Box")
 Some do (Sound)
	 
*/
//- (NSString *) getDefaultFile: (NSString *)eventname present: (int)present;

/** 
 Shortcut to -[KNotifyClient Instance]::-current :)

*/
//- (KInstance*) instance;
+ (int) Default;
+ (int) None;
+ (int) Sound;
+ (int) Messagebox;
+ (int) Logfile;
+ (int) Stderr;
+ (int) Notification;
+ (int) Warning;
+ (int) Error;
+ (int) Catastrophe;
+ (int) cannotOpenFile;
+ (int) notification;
+ (int) warning;
+ (int) fatalError;
+ (int) catastrophe;
@end

#endif
