/***************************************************************************
                            KProtocolInfo.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KPROTOCOLINFO_H
#define KPROTOCOLINFO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KSycocaEntry.h>

/**

 Information about I/O (Internet, etc.) protocols supported by KDE.

 This class is useful if you want to know which protocols
 KDE supports. In addition you can find out lots of information
 about a certain protocol. KProtocolInfo scans the *.protocol
 files of all installed kioslaves to get this information.

 *.protocol files are installed in the "services" resource.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Information about I/O (Internet, etc.
*/
@class KURL; 
@class QDataStream; 

@interface KProtocolInfo : KSycocaEntry 

/** 
 Read a protocol description file
   
*/
- initWithText: (NSString *)path;

/** 

*/
- (BOOL) isValid;

/** 

 This corresponds to the "protocol=" field in the protocol description file.

*/
- (NSString *) name;

/** 

   
*/
- initWithDataStream: (QDataStream *)_str offset: (int)offset;
- (void) dealloc;

/** 

 Load the protocol info from a stream.
   
*/
- load: (QDataStream *)arg1;

/** 

 Save the protocol info to a stream.
   
*/
- save: (QDataStream *)arg1;

/** 

*/
+ (NSArray *) protocols;

/** 

*/
+ (BOOL) isKnownProtocolForURL: (KURL*)url;

/** 

 This corresponds to the "exec=" field in the protocol description file.

   
*/
+ (NSString *) exec: (NSString *)protocol;

/**  

 This corresponds to the "input=" field in the protocol description file.
 Valid values for this field are "filesystem", "stream" or "none" (default).

   
*/
+ (int) inputTypeForURL: (KURL*)url;

/**  

 This corresponds to the "output=" field in the protocol description file.
 Valid values for this field are "filesystem", "stream" or "none" (default).

   
*/
+ (int) outputTypeForURL: (KURL*)url;

/** 

 This corresponds to the "listing=" field in the protocol description file.
 The supported fields should be seperated with ',' in the protocol description file.
   
*/
+ (NSArray *) listingForURL: (KURL*)url;

/** 

 The "source=" field in the protocol description file determines
 whether a protocol is a source protocol or a filter protocol.
 Valid values for this field are "true" (default) for source protocol or 
 "false" for filter protocol.
   
*/
+ (BOOL) isSourceProtocolForURL: (KURL*)url;

/** 

 This corresponds to the "helper=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) isHelperProtocolForURL: (KURL*)url;

/** 

 The "source=" field in the protocol description file determines
 whether a protocol is a source protocol or a filter protocol.
 Valid values for this field are "true" (default) for source protocol or 
 "false" for filter protocol.
   
*/
+ (BOOL) isFilterProtocolForURL: (KURL*)url;

/** 

 Whether a protocol supports listing is determined by the "listing=" 
 field in the protocol description file.
 If the protocol support listing it should list the fields it provides in
 this field. If the protocol does not support listing this field should
 remain empty (default.)

*/
+ (BOOL) supportsListingForURL: (KURL*)url;

/** 

 This corresponds to the "reading=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) supportsReadingForURL: (KURL*)url;

/** 

 This corresponds to the "writing=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) supportsWritingForURL: (KURL*)url;

/** 

 This corresponds to the "makedir=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) supportsMakeDirForURL: (KURL*)url;

/** 

 This corresponds to the "deleting=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) supportsDeletingForURL: (KURL*)url;

/** 

 This corresponds to the "linking=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) supportsLinkingForURL: (KURL*)url;

/** 

 This corresponds to the "moving=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) supportsMovingForURL: (KURL*)url;

/** 

 This corresponds to the "copyFromFile=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) canCopyFromFileForURL: (KURL*)url;

/** 

 This corresponds to the "copyToFile=" field in the protocol description file.
 Valid values for this field are "true" or "false" (default).
   
*/
+ (BOOL) canCopyToFileForURL: (KURL*)url;

/** 

 This corresponds to the "defaultMimetype=" field in the protocol description file.
   
*/
+ (NSString *) defaultMimetypeForURL: (KURL*)url;

/** 

 This corresponds to the "Icon=" field in the protocol description file.
   
*/
+ (NSString *) icon: (NSString *)protocol;

/** 

 This corresponds to the "config=" field in the protocol description file.
 The default is the protocol name, see @ref -name
   
*/
+ (NSString *) config: (NSString *)protocol;

/** 

 This corresponds to the "maxInstances=" field in the protocol description file.
 The default is 1.
   
*/
+ (int) maxSlaves: (NSString *)protocol;

/** 

 This corresponds to the "determineMimetypeFromExtension=" field in the protocol description file.
 Valid values for this field are "true" (default) or "false".
   
*/
+ (BOOL) determineMimetypeFromExtension: (NSString *)protocol;
+ (int) inputType: (NSString *)protocol;
+ (int) outputType: (NSString *)protocol;

/** 

*/
+ (NSArray *) listing: (NSString *)protocol;
+ (BOOL) isSourceProtocol: (NSString *)protocol;
+ (BOOL) isHelperProtocol: (NSString *)protocol;
+ (BOOL) isFilterProtocol: (NSString *)protocol;
+ (BOOL) isKnownProtocol: (NSString *)protocol;
+ (BOOL) supportsListing: (NSString *)protocol;
+ (BOOL) supportsReading: (NSString *)protocol;
+ (BOOL) supportsWriting: (NSString *)protocol;
+ (BOOL) supportsMakeDir: (NSString *)protocol;
+ (BOOL) supportsDeleting: (NSString *)protocol;
+ (BOOL) supportsLinking: (NSString *)protocol;
+ (BOOL) supportsMoving: (NSString *)protocol;
+ (BOOL) canCopyFromFile: (NSString *)protocol;
+ (BOOL) canCopyToFile: (NSString *)protocol;
+ (NSString *) defaultMimetype: (NSString *)protocol;
+ (int) T_STREAM;
+ (int) T_FILESYSTEM;
+ (int) T_NONE;
+ (int) T_ERROR;
@end

#endif
