/***************************************************************************
                            KShortcut.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSHORTCUT_H
#define KSHORTCUT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The KShortcut class is used to represent a keyboard shortcut to an action.
 A shortcut is normally a single key with modifiers, such as Ctrl+V.
 A KShortcut object may also contain an alternate key which will also
 activate the action it's associated to, as long as no other actions have
 defined that key as their primary key.  Ex: Ctrl+V;Shift+Insert.
 
 @short 
 The KShortcut class is used to represent a keyboard shortcut to an action.
*/
@class KKey; 
@class QKeySequence;

@interface  KShortcut : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- initWithInt: (int)keyQt;
- initWithQKeySequence: (QKeySequence*)arg1;
- initWithKey: (KKey*)arg1;
//- initWithKeySequence: (KKeySequence*)arg1;
- copyWithZone: (NSZone *) zone;
- initWithString: (NSString *)arg1;
//- initWithText: (NSString *)arg1;
- (void) dealloc;
- clear;
- (BOOL) isInitWithInt: (int)keyQt;
- (BOOL) isInitWithQKeySequence: (QKeySequence*)arg1;
- (BOOL) isInitWithKey: (KKey*)arg1;
//- (BOOL) isInitWithKeySequence: (KKeySequence*)arg1;
- (BOOL) isInitWithShortcut: (KShortcut*)arg1;
- (BOOL) isInitWithString: (NSString *)arg1;
- (unsigned int) count;
//- (KKeySequence*) seq: (unsigned int)i;
- (int) keyCodeQt;
- (BOOL) isNull;
- (int) compare: (KShortcut*)arg1;
- (BOOL) containsKey: (KKey*)arg1;
//- (BOOL) containsKeyNative: (KKeyNative*)arg1;
//- (BOOL) containsKeySequence: (KKeySequence*)arg1;
//- (BOOL) setSeq: (unsigned int)i keysequence: (KKeySequence*)arg1;
//- (BOOL) append: (KKeySequence*)arg1;
- (NSString *) toString;
- (NSString *) toStringInternal: (KShortcut*)pcutDefault;
+ (KShortcut*) null;
+ (int) MAX_SEQUENCES;
@end

#endif
