/***************************************************************************
                            KToggleAction.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTOGGLEACTION_H
#define KTOGGLEACTION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KAction.h>

/**

  Checkbox like action.

  This action provides two states: checked or not.

 @short Checkbox like action.
 
*/
@class QIconSet; 

@class QKeySequence; 

@class KShortcut; 

@interface KToggleAction : KAction 

/** 
 Constructs a toggle action with text and potential keyboard
 accelerator but nothing else. Use this only if you really
 know what you are doing.

*/
- initWithText: (NSString *)text cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text ;

/** 

*/
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmap: (QIconSet*)pix ;

/** 

*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmapFor: (NSString *)pix ;

/** 

*/
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmap: (QIconSet*)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent name: (NSString *)name;
- initWithText: (NSString *)text pixmapFor: (NSString *)pix cut: (KShortcut*)cut receiver: (QObject *)receiver slot: (NSString *)slot parent: (QObject *)parent ;

/** 

*/
- initWithObject: (QObject *)parent name: (NSString *)name;
- init;

/** 
 Destructor
     
*/
- (void) dealloc;

/** 
  "Plug" or insert this action into a given widget.

  This will typically be a menu or a toolbar.  From this point
  on, you will never need to directly manipulate the item in the
  menu or toolbar.  You do all enabling/disabling/manipulation
  directly with your KToggleAction object.

*/
- (int) plug: (QWidget *)arg1 index: (int)index;
- (int) plug: (QWidget *)arg1 ;

/** 
  Returns the actual state of the action.
     
*/
- (BOOL) isChecked;

/** 

*/
- (NSString *) exclusiveGroup;

/** 
 Defines which "exclusive group" this action is part of.
 In a given exclusive group, only one toggle action can be checked
 at a any moment. Checking an action unchecks the other actions
 of the group.
     
*/
- setExclusiveGroup: (NSString *)name;

/** 
  Setss the state of the action.
     
*/
- setChecked: (BOOL)arg1;
- setChecked: (int)identifier checked: (BOOL)checked;
- slotActivated;
@end

/** Override these methods in subclasses of KToggleAction to customise event handling behaviour */
@protocol KToggleActionEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
