/***************************************************************************
                            KToolBarRadioGroup.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KTOOLBARRADIOGROUP_H
#define KTOOLBARRADIOGROUP_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

 KToolBarRadioGroup is class for group of radio butons in toolbar.
 Take toggle buttons which you already inserted into toolbar,
 create KToolBarRadioGroup instance and add them here.
 All buttons will emit signals toggled (bool) (or you can
 use sitgnal @ref  #-toggled (int id) from toolbar). When one button is set
 down, all others are unset. All buttons emit signals - those who
 "go down" and those who "go up".

 @author Sven Radej <radej@kde.org>

 @short Class for group of radio butons in toolbar.
  
*/
@class KToolBar; 

@interface KToolBarRadioGroup : QObject 

/** 
 Constructor. Parent must be @ref KToolBar .
   
*/
- initWithToolBar: (KToolBar*)_parent _name: (NSString *)_name;
- initWithToolBar: (KToolBar*)_parent ;

/** 
 Destructor.
   
*/
- (void) dealloc;

/** 
 Adds button to group. Button cannot be unset by mouse clicks (you
 must press some other button tounset this one)
   
*/
- addButton: (int)identifier;

/** 
 Removes button from group, making it again toggle button (i.e.
 You can unset it with mouse).
   
*/
- removeButton: (int)identifier;

/** 
 Internal - nothing for you here.
   
*/
- slotToggled: (int)arg1;
@end

/** Override these methods in subclasses of KToolBarRadioGroup to customise event handling behaviour */
@protocol KToolBarRadioGroupEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
