/***************************************************************************
                            KUniqueApplication.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KUNIQUEAPPLICATION_H
#define KUNIQUEAPPLICATION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/DCOPObject.h>
#include <kdeobjc/KApplication.h>

/**

 Maintains only a single
 instance of a running application at a time.

 If another instance
 is started, it will determine (via DCOP) whether it is the first instance
 or a second instance.  If it is a second instance, it will forward on
 the information to the first instance and then quit.

 @author Preston Brown <pbrown@kde.org>
 
 @short 
 Maintains only a single
 instance of a running application at a time.
*/
@interface KUniqueApplication : KApplication 

/** 
 Constructor. Takes command line arguments from KCmdLineArgs
 Parameters : See @ref KApplication constructor.
 @p configUnique If true, the uniqueness of the application will
                 depend on the value of the "MultipleInstances"
                 key in the "KDE" group of the application config file.

   
*/
- initWithBOOL: (BOOL)allowStyles GUIenabled: (BOOL)GUIenabled configUnique: (BOOL)configUnique;
- init;

/**  Destructor 
*/
- (void) dealloc;

/** 
 Dispatches any incoming DCOP message for a new instance.

 If it is not a request for a new instance, return @p false.
   
*/
- (BOOL) process: (NSString *)fun data: (QByteArray*)data replyType: (NSString *)replyType replyData: (QByteArray*)replyData;

/** 
 Creates a new "instance" of the application.

 Usually this will involve making some calls into the GUI portion of your
 application asking for a new window to be created, possibly with
 some data already loaded based on the arguments received.

 Command line arguments have been passed to KCmdLineArgs before this
 function is called and can be checked in the usual way.

 Note that -newInstance is called also in the first started 
 application process.

*/
- (int) newInstance;

/** 
 Adds command line options specific for KUniqueApplication.

 Should be called before calling KUniqueApplication constructor
 and / or -start.
   
*/
+ addCmdLineOptions;

/** 
 Forks and registers with dcop.

 The command line arguments are being sent via DCOP to @ref -newInstance
 and will be received once the application enters the event loop.

 Typically this is used like:
 <pre>
 int main(int argc, char **argv) {
    KAboutData about("myappname", "myAppName", .....);
    -[KCmdLineArgs init](argc, argv, &about);
    -[KCmdLineArgs addCmdLineOptions]( myCmdOptions );
    -[KUniqueApplication addCmdLineOptions];

    if (!-[KUniqueApplication start]) {
       fprintf(stderr, "myAppName is already running!\n");
       exit(0);
    }
    KUniqueApplication a;
    a.-exec;
 }
 </pre>
 Note that it's not necessary to call @ref -start explicitly. It will be
 called automatically before creating KUniqueApplication if it hasn't
 been called yet, without any performance impact.
   
*/
+ (BOOL) start;
@end

@class DCOPClient; 

@interface KUniqueApplication (DCOPObjectImplementation) <DCOPObjectInterface>
@end

/** Override these methods in subclasses of KUniqueApplication to customise event handling behaviour */
@protocol KUniqueApplicationEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
