/***************************************************************************
                            Rect.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef RECT_H
#define RECT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The <code> Rect </code> interface is used to represent any <a
 href="http://www.w3.org/TR/REC-CSS2/visufx.-[html value]-def-shape">
 rect </a> value. This interface reflects the values in the
 underlying style property. Hence, modifications made through this
 interface modify the style property.

 
 @short 
 The <code> Rect </code> interface is used to represent any <a
 href="http://www.
*/
@class CSSPrimitiveValue; 

@interface  Rect : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;

/** 
 This attribute is used for the top of the rect.

     
*/
- (CSSPrimitiveValue*) top;

/** 
 This attribute is used for the right of the rect.

     
*/
- (CSSPrimitiveValue*) right;

/** 
 This attribute is used for the bottom of the rect.

     
*/
- (CSSPrimitiveValue*) bottom;

/** 
 This attribute is used for the left of the rect.

     
*/
- (CSSPrimitiveValue*) left;
- (BOOL) isNull;
@end

#endif
