<?xml version="1.0" encoding="utf-8"?>
<!--
  ** Author: Marco Ladermann
  ** Date:   Wed Jan 29 08:41:56 CET 2003 @362 /Internet Time/
  ** Purpose:  Convert tags in the UI file to Qt classes 
  ** Changed:
  **
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>

      <!--
      ** Start of mode 'classes'
      ** The patterns with mode "classes" construct a
      ** result tree fragment of "class" elements with the 
      ** Qt classes that should be used for a ui tag.
      -->
    <xsl:template match="action" mode="classes">
        <class>QAction</class>
        <class>QKeySequence</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>
  
    <xsl:template match="actiongroup" mode="classes">
        <class>QActionGroup</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>
  
    <xsl:template match="color" mode="classes">
        <class>QColor</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="cursor" mode="classes">
        <class>QCursor</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="font" mode="classes">
        <class>QFont</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="grid" mode="classes">
        <class>QGridLayout</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="hbox" mode="classes">
        <class>QHBoxLayout</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="iconset" mode="classes">
        <class>QIconSet</class>
        <class>QPixmap</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="item" mode="classes">
        <xsl:if test="name(..) = 'widget'">
            <class><xsl:value-of select="concat(../@class, 'Item')"/></class>
        </xsl:if>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="menubar" mode="classes">
        <class>QMenuBar</class>
        <class>QPopupMenu</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="pixmap" mode="classes">
        <class>QPixmap</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="rect" mode="classes">
        <class>QRect</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="size" mode="classes">
        <class>QSize</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="sizepolicy" mode="classes">
        <class>QSizePolicy</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="spacer" mode="classes">
        <class>QSpacerItem</class>
        <class>QSizePolicy</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="toolbar" mode="classes">
        <class>QToolBar</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="vbox" mode="classes">
        <class>QVBoxLayout</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>
  
    <xsl:template match="palette" mode="classes">
        <class>QPalette</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="active|disabled|inactive" mode="classes">
        <class>QColorGroup</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="widget[not(@class = 'QLayoutWidget')]" mode="classes">
        <class><xsl:value-of select="@class"/></class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="property[@name = 'toolTip']" mode="classes">
        <class>QToolTip</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="property[@name = 'whatsThis']" mode="classes">
        <class>QWhatsThis</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="property[@name = 'database']" mode="classes">
        <class>QSqlDatabase</class>
        <class>QSqlCursor</class>
        <xsl:apply-templates mode="classes"/>
    </xsl:template>

    <xsl:template match="text()|@*" mode="classes"/>
    
    <!--
      ** End of mode 'classes'
      -->

    <!--
      ** A mode to get classes corresponding to the tag names. This templates
      ** do not recurse and return a simple text value
      -->
    <xsl:template match="action" mode="toClass">
        <xsl:text>QAction</xsl:text>
    </xsl:template>
    <xsl:template match="actiongroup" mode="toClass">
        <xsl:text>QActionGroup</xsl:text>
    </xsl:template>
    <xsl:template match="grid" mode="toClass">
        <xsl:text>QGridLayout</xsl:text>
    </xsl:template>
    <xsl:template match="hbox" mode="toClass">
        <xsl:text>QHBoxLayout</xsl:text>
    </xsl:template>
    <xsl:template match="iconset" mode="toClass">
        <xsl:text>QIconSet</xsl:text>
    </xsl:template>
    <xsl:template match="menubar" mode="toClass">
        <xsl:text>QMenuBar</xsl:text>
    </xsl:template>
    <xsl:template match="pixmap" mode="toClass">
        <xsl:text>QPixmap</xsl:text>
    </xsl:template>
    <xsl:template match="spacer" mode="toClass">
        <xsl:text>QSpacerItem</xsl:text>
    </xsl:template>
    <xsl:template match="toolbar" mode="toClass">
        <xsl:text>QToolBar</xsl:text>
    </xsl:template>
    <xsl:template match="vbox" mode="toClass">
        <xsl:text>QVBoxLayout</xsl:text>
    </xsl:template>
    <xsl:template match="widget" mode="toClass">
        <xsl:value-of select="@class"/>
    </xsl:template>
    <xsl:template match="*" mode="toClass">
        <xsl:message terminate="yes">Upps! Which class? <xsl:value-of select="name(.)"/></xsl:message>
    </xsl:template>
    
</xsl:stylesheet>

