/***************************************************************************
                            QSqlDatabase.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QSQLDATABASE_H
#define QSQLDATABASE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**

*
* Definition of QSqlDriver class
*
* Created : 2000-11-03
*
* Copyright (C) 2000 Trolltech AS.  All rights reserved.
*
* This file is part of the sql module of the Qt GUI Toolkit.
*
* This file may be distributed under the terms of the Q Public License
* as defined by Trolltech AS of Norway and appearing in the file
* LICENSE.QPL included in the packaging of this file.
*
* This file may be distributed and/or modified under the terms of the
* GNU General Public License version 2 as published by the Free Software
* Foundation and appearing in the file LICENSE.GPL included in the
* packaging of this file.
*
* Licensees holding valid Qt Enterprise Edition licenses may use this
* file in accordance with the Qt Commercial License Agreement provided
* with the Software.
*
* This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
* WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*
* See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
*   information about Qt Commercial License Agreements.
* See http://www.trolltech.com/qpl/ for QPL licensing information.
* See http://www.trolltech.com/gpl/ for GPL licensing information.
*
* Contact info@trolltech.com if any conditions of this licensing are
* not clear to you.
*
********************************************************************
 @short 
*
* Definition of QSqlDriver class
*
* Created : 2000-11-03
*
* Copyright (C) 2000 Trolltech AS.
*/
@class QSqlDriver; 
@class QSqlError;
@class QSqlIndex; 
@class QSqlQuery; 
@class QSqlRecord; 

@interface QSqlDatabase : QObject 
- (void) dealloc;
- (BOOL) open;
- (BOOL) open: (NSString *)user password: (NSString *)password;
- close;
- (BOOL) isOpen;
- (BOOL) isOpenError;
- (NSArray *) tables;
- (QSqlIndex*) primaryIndex: (NSString *)tablename;
- (QSqlRecord*) recordForTable: (NSString *)tablename;
- (QSqlRecord*) recordForQuery: (QSqlQuery*)query;
//- (QSqlRecordInfo*) recordInfoForTable: (NSString *)tablename;
//- (QSqlRecordInfo*) recordInfoForQuery: (QSqlQuery*)query;
- (QSqlQuery*) exec: (NSString *)query;
- (QSqlQuery*) exec;
- (QSqlError*) lastError;
- (BOOL) transaction;
- (BOOL) commit;
- (BOOL) rollback;
- setDatabaseName: (NSString *)name;
- setUserName: (NSString *)name;
- setPassword: (NSString *)password;
- setHostName: (NSString *)host;
- setPort: (int)p;
- (NSString *) databaseName;
- (NSString *) userName;
- (NSString *) password;
- (NSString *) hostName;
- (NSString *) driverName;
- (int) port;
- (QSqlDriver*) driver;
+ (QSqlDatabase*) addDatabase: (NSString *)type connectionName: (NSString *)connectionName;
+ (QSqlDatabase*) addDatabase: (NSString *)type ;
+ (QSqlDatabase*) database: (NSString *)connectionName open: (BOOL)open;
+ (QSqlDatabase*) database;
+ removeDatabase: (NSString *)connectionName;
+ (BOOL) contains: (NSString *)connectionName;
+ (BOOL) contains;
+ (NSArray *) drivers;
//+ registerSqlDriver: (NSString *)name dcb: (QSqlDriverCreatorBase*)dcb;
- initWithText: (NSString *)type name: (NSString *)name parent: (QObject *)parent objname: (NSString *)objname;
- initWithText: (NSString *)type name: (NSString *)name ;
@end

/** Override these methods in subclasses of QSqlDatabase to customise event handling behaviour */
@protocol QSqlDatabaseEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
