namespace Binge.Generators.CSharp
{
	using System;
	using System.Collections;
	using Binge.Bits;
	using Binge.Generators;

	/* C# conversion preprocessor checklist
	 *
	 * Please add anything you can think of. :)
	 *
	 * o Multiple inheritance resolution
	 * o Reserved word resolution
	 * o Array type resolution
	 * o out/ref parameter resolution
	 * o C++ -> C# return and param type mapping
	 * o C# PInvoke call return and param type mapping
	 * o Analyze methods and apply virtual, override, and new
	 *   flags where appropriate.
	 */

	public class GlueStick: Binge.Generators.GlueStick
	{
		public override void Glue (Property prop)
		{
			// FIXME
			// If underlying, generate glue, else
			// let another GlueStick generate code.
		}

		void Glue (MethodBase method)
		{
			Import (method);
			Overload (method);
		}

		public override void Glue (Constructor ctor)
		{
			Glue (ctor as MethodBase);

			// FIXME Make base/this call glue
			// FIXME Make P/Invoke call glue
		}

		public override void Glue (Destructor dtor)
		{
			Glue (dtor as MethodBase);

			// FIXME Make Dispose glue
			// FIXME Make P/Invoke call glue
		}

		public override void Glue (Method method)
		{
			Glue (method as MethodBase);

			ArrayList g = method.Glue;

			string s = String.Empty;

			if (method.Returns.NativeType != "void")
				s += "return ";

			s += method.NativeName + " (";

			for (int i=0; i<method.Parameters.Count; i++)
			{
				Parameter p = (Parameter)method.Parameters[i];
				if (p.MarshallName != String.Empty)
					s += p.MarshallName;
				else if (p.TargetName != String.Empty)
					s += p.TargetName;
				else
					s += p.NativeName;

				if (method.Parameters.Count - i > 1)
					s += ", ";
			}

			s += ");";

			method.Glue.Add (s);
		}

		void Import (MethodBase method)
		{
			if (method is Destructor)
				return;

			Binge.Bits.Attribute attr = new Binge.Bits.Attribute ();

			attr.Name = "DllImport";

			if (method is Method)
				attr.Args.Add ("\"" + TargetLibrary + "\"");
			else
				attr.Args.Add ("\"" + GlueLibrary + "\"");

			attr.KwArgs["CharSet"] = "CharSet.Ansi";
			
			//FIXME MangledName needs to be hooked up to the Mangler.
			attr.KwArgs["EntryPoint"] = "MangledName";
			
			Method imported = new Method ();
			imported.Attributes.Add (attr);
			imported.Access = MemberAccess.Private;
			imported.NativeName = method.NativeName;
			imported.IsStatic = true;
			imported.IsExtern = true;
			imported.Parent = method.Parent;

			if (method is Method)
			{
				//FIXME  The pinvoke method name should be the camelCase name
				//if (Mangler != null)
				//	imported.TargetName = Mangler.Mangle (method);
				imported.TargetName = method.NativeName;
				
				imported.Returns = method.Returns;
				// FIXME Generate support library glue
			}
			else if (method is Constructor)
			{
				imported.NativeName = "new_" + method.NativeName;
				// FIXME Generate support library glue
			}
			else if (method is Destructor)
			{
				imported.NativeName = "del_" + method.NativeName;
				// FIXME Generate support library glue
			}

			foreach (Parameter p in method.Parameters)
			{
				Parameter newp = new Parameter ();
				newp.NativeType = p.TargetType != String.Empty ?
					p.TargetType : p.NativeType;
				newp.NativeName = p.TargetName != String.Empty ?
					p.TargetName : p.NativeName;

				newp.IsConst = p.IsConst;
				newp.PassBy = p.PassBy;
				newp.Default = p.Default;

				imported.Parameters.Add (newp);

			}

			method.Parent.ImportedMethods.Add (imported);

			return;
		}

		void Overload (MethodBase method)
		{
			if (method is Destructor)
				return;

			// For each method parameter
			for (int i=0; i<method.Parameters.Count; i++)
			{
				Parameter p = method.Parameters[i] as Parameter;

				// No default, no need to overload.
				if (p.Default == String.Empty)
					continue;

				// Create a Method instance for this overload
				MethodBase clone = method.Clone () as MethodBase;
				clone.Parameters.Clear ();
				clone.Overloads.Clear ();

				// Clone parameters up to current index.
				int j;

				for (j=0; i>0 && j<i; j++)
				{
					Parameter cp = method.Parameters[j] as Parameter;
					Parameter ccp = cp.Clone () as Parameter;;
					cp = cp.Clone () as Parameter;

					// Method parameter list
					clone.Parameters.Add (cp);

					// Overload call parameter list
					ccp.Default = String.Empty;
					clone.CallParameters.Add (ccp);
				}

				// Overload call parameter defaults
				for (/* j */; j<method.Parameters.Count; j++)
				{
					Parameter cp = method.Parameters[j] as Parameter;
					cp = cp.Clone () as Parameter;
					clone.CallParameters.Add (cp);
				}

				if (method is Constructor)
				{
					// Use ': this (...)' calling form
					Constructor ctor = clone as Constructor;
					ctor.CallType = Constructor.CallTypes.This;
				}
				else if (method is Method)
				{
					// Print method call glue
					string ret = clone.Returns.TargetType != String.Empty ?
						clone.Returns.TargetType : clone.Returns.NativeType;

					string name = clone.TargetName != String.Empty ?
						clone.TargetName : clone.NativeName;

					string line = (ret == "void" ? "" : "return ") + name + " (";

					for (int k=0; k<clone.CallParameters.Count; k++)
					{
						Parameter cp = clone.CallParameters[k] as Parameter;
						string cpname = cp.TargetName != String.Empty ?
							cp.TargetName : cp.NativeName;

						string val = cp.Default != String.Empty ?
							cp.Default : cpname;

						line += val;

						if (clone.CallParameters.Count - k > 1)
							line += ", ";
					}

					line += ");";

					clone.Glue.Clear ();
					clone.Glue.Add (line);
				}

				// Done
				method.Overloads.Add (clone);
			}
		}
	}
}
