/*
 * system dependent wrapper for access to cdrom
 * Copyright (C) 1999  Martin Vogt
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation.
 *
 *  For more information look at the file COPYRIGHT in this package
 *
 * $Id: cdromAccess.cpp,v 1.6 2003/10/05 16:53:05 adrian Exp $
 *
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#endif



#ifdef OS_AIX 
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef OS_Linux
  #include <linux/version.h>
#if 0
/* this breaks the build on ia64 and s390 for example.
   sys/types.h is already included and should provide __u64.
   please tell where we really need this and let's try to find
   a working #if case for everyone ... adrian@suse.de */
  #if LINUX_VERSION_CODE >= KERNEL_VERSION(2,5,50)
  typedef unsigned long long  __u64;
  #endif
#endif
  #include "cdromAccess_Linux.cpp"
#endif

#ifdef OS_BSD
  #include "cdromAccess_Empty.cpp"
#endif

#if defined(OS_IRIX) || defined(OS_IRIX64)
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef OS_HPUX
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef OS_SunOS
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef __BEOS__
  #include "cdromAccess_Empty.cpp"
#endif

#ifdef WIN32
  #include "cdromAccess_Empty.cpp"
#endif


