#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>    
#include <gdk/gdk.h>    
#include <gdk/gdkx.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <libxfce4util/i18n.h>
#include <libxfce4util/util.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4mcs/mcs-client.h>
#include <libxfce4util/debug.h>

#include "ls_iconboxconf.h"
#include "inline-icon.h"

#define CHANNEL "xfibx"
#define LS_HEADER N_("Lil' Star - Iconbox")
#define LS_TITLE N_("Lil' Star - Iconbox")


/* CALLBACKS									*/
static void cb_lsibc_alignment(GtkWidget *pWidget, gpointer pUserData);
static void cb_lsibc_show(GtkWidget *pWidget, gpointer pUserData);
static void cb_lsibc_color(GtkWidget *pWidget, gpointer pUserData);
static void cb_lsibc_hide(GtkWidget *pWidget, gpointer pUserData);
  

LSIconBoxConf *ls_iconboxconf_create_configwin(LSIconBoxWin *plsibw)
{
  LSIconBoxConf		*p;
  LSIconBoxConfPrivate	*pp;
  GdkPixbuf		*pIcon;
  GtkWindow		*pWin;
  GtkWidget		*pDialogHeader;
  GtkFrame		*pFrame;
  GtkHBox		*pHBox;
 
  /* This is required for UTF-8 at least - Please don't remove it  */
  xfce_textdomain(GETTEXT_PACKAGE, LOCALEDIR, "UTF-8");

  p = (LSIconBoxConf *)g_malloc(sizeof(LSIconBoxConf));
  pp = p->priv =
    (LSIconBoxConfPrivate *)g_malloc(sizeof(LSIconBoxConfPrivate));
  p->priv->pmcsManager = NULL;

  pWin = pp->pWindow = pp->widgets.pWindow = GTK_WINDOW(gtk_dialog_new());
  gtk_window_set_resizable(GTK_WINDOW(pWin), FALSE);
  gtk_window_set_title(GTK_WINDOW(pWin), _(LS_TITLE));
  gtk_dialog_set_has_separator(GTK_DIALOG(pWin), FALSE);
  
  pIcon = inline_icon_at_size(default_icon_data_48_48, 32, 32);
  pDialogHeader = create_header(pIcon, _(LS_HEADER));

  gtk_window_set_icon(GTK_WINDOW(pWin), pIcon);
  g_object_unref(pIcon);
  
  /* START GLOBAL								*/
  pp->widgets.main = GTK_VBOX(GTK_DIALOG(pWin)->vbox);
  gtk_box_pack_start(GTK_BOX(pp->widgets.main), GTK_WIDGET(pDialogHeader),
    TRUE, TRUE, 0);
  /* END GLOBAL									*/

  /* START first frame								*/
  pFrame = GTK_FRAME(xfce_framebox_new (_("Alignment"), TRUE));
  gtk_box_pack_start(GTK_BOX(pp->widgets.main), GTK_WIDGET(pFrame),
    FALSE, FALSE, 0);
  pp->widgets.frame_1		= GTK_VBOX(gtk_vbox_new(FALSE, 0));
  xfce_framebox_add (XFCE_FRAMEBOX (pFrame), GTK_WIDGET(pp->widgets.frame_1));

  pp->widgets.frame_1_btn_group_1[0] =
    GTK_RADIO_BUTTON(gtk_radio_button_new_with_label(NULL, 
      _("Horizontal, growing to the right")));
  pp->widgets.frame_1_btn_group_1[1] =
    GTK_RADIO_BUTTON(gtk_radio_button_new_with_label(
      gtk_radio_button_get_group(pp->widgets.frame_1_btn_group_1[0]),
      _("Horizontal, growing to the left")));
  pp->widgets.frame_1_btn_group_1[2] =
    GTK_RADIO_BUTTON(gtk_radio_button_new_with_label(
      gtk_radio_button_get_group(pp->widgets.frame_1_btn_group_1[0]),
      _("Vertical, growing downwards")));
  pp->widgets.frame_1_btn_group_1[3] =
    GTK_RADIO_BUTTON(gtk_radio_button_new_with_label(
      gtk_radio_button_get_group(pp->widgets.frame_1_btn_group_1[0]),
      _("Vertical, growing upwards")));

  gtk_box_pack_start(GTK_BOX(pp->widgets.frame_1), 
    GTK_WIDGET(pp->widgets.frame_1_btn_group_1[0]), FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pp->widgets.frame_1), 
    GTK_WIDGET(pp->widgets.frame_1_btn_group_1[1]), FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pp->widgets.frame_1), 
    GTK_WIDGET(pp->widgets.frame_1_btn_group_1[2]), FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pp->widgets.frame_1), 
    GTK_WIDGET(pp->widgets.frame_1_btn_group_1[3]), FALSE, FALSE, 0);
  /* END first frame								*/
  /* START second frame								*/
  pFrame = GTK_FRAME(xfce_framebox_new (_("Appearance"), TRUE));
  gtk_box_pack_start(GTK_BOX(pp->widgets.main), GTK_WIDGET(pFrame), 
    FALSE, FALSE, 0);
  pp->widgets.frame_2		= GTK_VBOX(gtk_vbox_new(FALSE, 0));
  xfce_framebox_add (XFCE_FRAMEBOX (pFrame), GTK_WIDGET(pp->widgets.frame_2));

  pp->widgets.frame_2_btn_group_1[0] =
    GTK_RADIO_BUTTON(gtk_radio_button_new_with_label(NULL, _("Minimized only")));
  pp->widgets.frame_2_btn_group_1[1] =
    GTK_RADIO_BUTTON(gtk_radio_button_new_with_label(
      gtk_radio_button_get_group(pp->widgets.frame_2_btn_group_1[0]),
      _("All Apps")));

  pHBox = GTK_HBOX(gtk_hbox_new(FALSE, 0));

  gtk_box_pack_start(GTK_BOX(pHBox), 
    GTK_WIDGET(pp->widgets.frame_2_btn_group_1[0]), FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pHBox), 
    GTK_WIDGET(pp->widgets.frame_2_btn_group_1[1]), FALSE, FALSE, 0);

  pp->widgets.frame_2_btn_1 = 
    GTK_CHECK_BUTTON(gtk_check_button_new_with_label(_("Show All Workspaces")));
  pp->widgets.frame_2_btn_2 = 
    GTK_CHECK_BUTTON(gtk_check_button_new_with_label(_("Use Colors")));
  pp->widgets.frame_2_btn_3 =
    GTK_CHECK_BUTTON(gtk_check_button_new_with_label(_("Hide if empty")));

  gtk_box_pack_start(GTK_BOX(pp->widgets.frame_2), GTK_WIDGET(pHBox),
    FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pp->widgets.frame_2), 
    GTK_WIDGET(pp->widgets.frame_2_btn_1), FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pp->widgets.frame_2), 
    GTK_WIDGET(pp->widgets.frame_2_btn_2), FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pp->widgets.frame_2), 
    GTK_WIDGET(pp->widgets.frame_2_btn_3), FALSE, FALSE, 0);
  /* STOP second frame								*/

  /* START PACK FRAME								*/
  pp->widgets.close	= GTK_BUTTON(gtk_button_new_from_stock(GTK_STOCK_CLOSE));
  gtk_dialog_add_action_widget(GTK_DIALOG(pWin), GTK_WIDGET(pp->widgets.close), 
    GTK_RESPONSE_CLOSE);
  GTK_WIDGET_SET_FLAGS(pp->widgets.close, GTK_CAN_DEFAULT);
  /* STOP PACK FRAME								*/
  /* REGISTER ACTION LISTENER							*/
  /* STOP REGISTER								*/
  
  gtk_window_set_position(GTK_WINDOW(pWin), GTK_WIN_POS_CENTER);

  return p;
};

void ls_iconboxconf_connect_signals(LSIconBoxConf *plsibw)
{
  LSIconBoxConfPrivate *pp;

  pp = plsibw->priv;
  
  /* START FIRST FRAME								*/
  g_signal_connect(G_OBJECT(pp->widgets.frame_1_btn_group_1[0]), 
    "toggled", G_CALLBACK(cb_lsibc_alignment), plsibw);
  g_signal_connect(G_OBJECT(pp->widgets.frame_1_btn_group_1[1]), 
    "toggled", G_CALLBACK(cb_lsibc_alignment), plsibw);
  g_signal_connect(G_OBJECT(pp->widgets.frame_1_btn_group_1[2]), 
    "toggled", G_CALLBACK(cb_lsibc_alignment), plsibw);
  g_signal_connect(G_OBJECT(pp->widgets.frame_1_btn_group_1[3]), 
    "toggled", G_CALLBACK(cb_lsibc_alignment), plsibw);
    
  /* START SECOND FRAME								*/
  g_signal_connect(G_OBJECT(pp->widgets.frame_2_btn_group_1[0]), 
    "toggled", G_CALLBACK(cb_lsibc_show), plsibw);
  g_signal_connect(G_OBJECT(pp->widgets.frame_2_btn_group_1[1]), 
    "toggled", G_CALLBACK(cb_lsibc_show), plsibw);

  g_signal_connect(G_OBJECT(pp->widgets.frame_2_btn_1), 
    "toggled", G_CALLBACK(cb_lsibc_show), plsibw);
  g_signal_connect(G_OBJECT(pp->widgets.frame_2_btn_2), 
    "toggled", G_CALLBACK(cb_lsibc_color), plsibw);
  g_signal_connect(G_OBJECT(pp->widgets.frame_2_btn_3), 
    "toggled", G_CALLBACK(cb_lsibc_hide), plsibw);
  /* STOP THIRD TAB								*/
};


void ls_iconboxconf_re_evaluate_settings(LSIconBoxConf *plsibc)
{
  LSIconBoxConfPrivate 	*pp;
  McsSetting		*pSetting;
  McsSetting		*pSetting2;
  McsSetting		*pSetting3;
  McsSetting		*pSetting4;
  McsManager		*pManager;

  pp		= plsibc->priv;
  pManager	= plsibc->priv->pmcsManager;

  pSetting 	=  mcs_manager_setting_lookup(pManager,
  		     "Window/Position/Horizontal", CHANNEL);
  pSetting2	= mcs_manager_setting_lookup(pManager,
		    "Window/Orientation", CHANNEL);
  pSetting3 	=  mcs_manager_setting_lookup(pManager,
  		     "Window/Position/Vertical", CHANNEL);

  if(pSetting && pSetting2 && pSetting3)
  {
    if(
      pSetting2->data.v_int == LS_ICONBOX_HORIZONTAL &&
      pSetting->data.v_int == LS_ICONBOX_LEFT
    ) {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_1_btn_group_1[0]), TRUE);
    } 
    else if(
      pSetting2->data.v_int == LS_ICONBOX_HORIZONTAL &&
      pSetting->data.v_int == LS_ICONBOX_RIGHT
    ) {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_1_btn_group_1[1]), TRUE);
    } 
    else if(
      pSetting2->data.v_int == LS_ICONBOX_VERTICAL &&
      pSetting3->data.v_int == LS_ICONBOX_TOP
    ) {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_1_btn_group_1[2]), TRUE);
    } 
    else if(
      pSetting2->data.v_int == LS_ICONBOX_VERTICAL &&
      pSetting3->data.v_int == LS_ICONBOX_BOTTOM
    ) {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_1_btn_group_1[3]), TRUE);
    }
    else
    {
      DBG("this should not happen!");
    };
  }
  else
  {
    DBG("this should not happen!");
  };

  pSetting	= mcs_manager_setting_lookup(pManager,
		    "Icon/Show/SameWS/Minimized", CHANNEL);
  pSetting2	= mcs_manager_setting_lookup(pManager,
		    "Icon/Show/SameWS/Maximized", CHANNEL);
  pSetting3	= mcs_manager_setting_lookup(pManager,
		    "Icon/Show/OtherWS/Minimized", CHANNEL);
  pSetting4	= mcs_manager_setting_lookup(pManager,
		    "Icon/Show/OtherWS/Maximized", CHANNEL);
  if(pSetting && pSetting2 && pSetting3 && pSetting4)
  {
    if(pSetting->data.v_int && !pSetting2->data.v_int)
    {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_group_1[0]), TRUE);
    }
    else if(pSetting->data.v_int && pSetting2->data.v_int)
    {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_group_1[1]), TRUE);
    }

    if(pSetting3->data.v_int || pSetting4->data.v_int)
    {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_1), TRUE);
    }
    else
    {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_1), FALSE);
    };
  }
  else
  {
    DBG("this should not happen!");
  };
    
  pSetting	= mcs_manager_setting_lookup(pManager,
      		    "Icon/Color/Use", CHANNEL);
  if(pSetting)
  {
    if(pSetting->data.v_int)
    {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_2), TRUE);
    }
    else
    {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_2), FALSE);
    };
  };
      
  pSetting	= mcs_manager_setting_lookup(pManager,
      		    "Window/HideOnEmpty", CHANNEL);
  if(pSetting)
  {
    if(pSetting->data.v_int == 1)
    {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_3), TRUE);
    }
    else
    {
      gtk_toggle_button_set_active(
        GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_3), FALSE);
    };
  };

  return;
};

void ls_iconboxconf_set_mcsmanager(
  LSIconBoxConf *plsibw, 
  McsManager *pmcsm
) {
  plsibw->priv->pmcsManager = pmcsm;
};

gboolean ls_iconboxconf_write(LSIconBoxConf *plsibwcw, McsManager *pmcsm)
{
  const gchar 	*szHome;
  gchar		*szRcFile;
  gboolean	bErr;

  szHome 	= g_get_home_dir(); 
  szRcFile	= g_strconcat(szHome, G_DIR_SEPARATOR_S, ".xfce4", 
      		    G_DIR_SEPARATOR_S, "settings", G_DIR_SEPARATOR_S, 
		    "ls-iconbox.xml", NULL);

  if(plsibwcw == NULL) 
  {
    DBG("plsibwcw==NULL use fallback manager and set internal manager");
  }
  else if(plsibwcw->priv->pmcsManager != NULL)
  {
    DBG("plsibwcw!=NULL use own manager");
    pmcsm = plsibwcw->priv->pmcsManager;
  }
  else
  {
    DBG("plsibwcw==NULL use own manager==NULL this should not happen!");
    return FALSE;
  };

  mcs_manager_set_int(pmcsm, "Config/Write", CHANNEL, 1);
  bErr		= mcs_manager_save_channel_to_file(pmcsm,
      		    CHANNEL, szRcFile);

  g_free(szRcFile);

  return bErr;
};

gboolean ls_iconboxconf_read(LSIconBoxConf *plsibwcw, McsManager *pmcsm)
{
  const gchar 	*szHome;
  gchar		*szRcFile;

  szHome 	= g_get_home_dir(); 
  szRcFile	= g_strconcat(szHome, G_DIR_SEPARATOR_S, ".xfce4", 
      		    G_DIR_SEPARATOR_S, "settings", G_DIR_SEPARATOR_S,
		    "ls-iconbox.xml", NULL);

  if(plsibwcw == NULL) 
  {
    DBG("plsibwcw==NULL use fallback manager and set internal manager");
  }
  else if(plsibwcw->priv->pmcsManager != NULL)
  {
    DBG("plsibwcw!=NULL use own manager");
    pmcsm = plsibwcw->priv->pmcsManager;
  }
  else
  {
    DBG("plsibwcw==NULL use own manager==NULL this should not happen!");
    return FALSE;
  };
  
  mcs_manager_add_channel_from_file(pmcsm, CHANNEL, szRcFile);
  mcs_manager_set_int(pmcsm, "Config/Read", CHANNEL, 1);

  g_free(szRcFile);

  return TRUE;
};

void ls_iconboxconf_open_channel(LSIconBoxConf *plsibwcw)
{
  g_return_if_fail(plsibwcw!=NULL);
  plsibwcw->priv->pmcsManager = mcs_manager_new(TRUE, GDK_DISPLAY(), 
    XDefaultScreen(GDK_DISPLAY()), NULL, NULL, NULL);
};

void ls_iconboxconf_close_channel(LSIconBoxConf *plsibwcw)
{
  g_return_if_fail(plsibwcw!=NULL);
    mcs_manager_destroy(plsibwcw->priv->pmcsManager);
};

/********************************************************************************/
/* CALLBACKS									*/ 
/********************************************************************************/
static void cb_lsibc_alignment(GtkWidget *pWidget, gpointer pUserData)
{
  LSIconBoxConf 	*plsibwcw;
  McsManager		*pManager;
  LSIconBoxConfPrivate	*pp;
  
  g_return_if_fail(pUserData!=NULL);
  plsibwcw		= pUserData;
  pp			= plsibwcw->priv;
  pManager		= plsibwcw->priv->pmcsManager;
  g_return_if_fail(pManager!=NULL);

  
  
  if (
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON(pp->widgets.frame_1_btn_group_1[0]))
  ) {
    mcs_manager_set_int(pManager, "Window/Orientation", CHANNEL, 
      LS_ICONBOX_HORIZONTAL);
    mcs_manager_set_int(pManager, "Window/Position/Horizontal", CHANNEL, 
      LS_ICONBOX_LEFT);
    mcs_manager_set_int(pManager, "Window/Position/Vertical", CHANNEL, 
      LS_ICONBOX_BOTTOM);
  }
  else if (
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON(pp->widgets.frame_1_btn_group_1[1]))
  ) {
    mcs_manager_set_int(pManager, "Window/Orientation", CHANNEL, 
      LS_ICONBOX_HORIZONTAL);
    mcs_manager_set_int(pManager, "Window/Position/Horizontal", CHANNEL, 
      LS_ICONBOX_RIGHT);
    mcs_manager_set_int(pManager, "Window/Position/Vertical", CHANNEL, 
      LS_ICONBOX_BOTTOM);
  }
  else if (
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON(pp->widgets.frame_1_btn_group_1[2]))
  ) {
    mcs_manager_set_int(pManager, "Window/Orientation", CHANNEL, 
      LS_ICONBOX_VERTICAL);
    mcs_manager_set_int(pManager, "Window/Position/Horizontal", CHANNEL, 
      LS_ICONBOX_RIGHT);
    mcs_manager_set_int(pManager, "Window/Position/Vertical", CHANNEL, 
      LS_ICONBOX_TOP);
  }
  else if (
    gtk_toggle_button_get_active(
      GTK_TOGGLE_BUTTON(pp->widgets.frame_1_btn_group_1[3]))
  ) {
    mcs_manager_set_int(pManager, "Window/Orientation", CHANNEL, 
      LS_ICONBOX_VERTICAL);
    mcs_manager_set_int(pManager, "Window/Position/Horizontal", CHANNEL, 
      LS_ICONBOX_RIGHT);
    mcs_manager_set_int(pManager, "Window/Position/Vertical", CHANNEL, 
      LS_ICONBOX_BOTTOM);
  }
  else
  {
    DBG("this should not happen!");
    return;
  };
      
  mcs_manager_notify(pManager, CHANNEL);
  ls_iconboxconf_write(plsibwcw, NULL);

  return;
};

static void cb_lsibc_show(GtkWidget *pWidget, gpointer pUserData)
{ 
  LSIconBoxConf 	*plsibwcw;
  McsManager		*pManager;
  LSIconBoxConfPrivate	*pp;
  gboolean		bAllApps;
  gboolean		bAllWS;

  g_return_if_fail(pUserData!=NULL);
  plsibwcw		= pUserData;
  pp			= plsibwcw->priv;
  pManager		= plsibwcw->priv->pmcsManager;
  g_return_if_fail(pManager!=NULL);

  bAllApps	= gtk_toggle_button_get_active(
      		    GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_group_1[1]));
  bAllWS	= gtk_toggle_button_get_active(
      		    GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_1));

  mcs_manager_set_int(pManager, "Icon/Show/SameWS/Minimized", CHANNEL, 1);
  mcs_manager_set_int(pManager, "Icon/Show/SameWS/SkipTaskbar", CHANNEL, 0);
  mcs_manager_set_int(pManager, "Icon/Show/OtherWS/SkipTaskbar", CHANNEL, 0);
  
  if(bAllApps==TRUE)
    mcs_manager_set_int(pManager, "Icon/Show/SameWS/Maximized", CHANNEL, 1);
  else
    mcs_manager_set_int(pManager, "Icon/Show/SameWS/Maximized", CHANNEL, 0);

  if(bAllWS==TRUE && bAllApps==TRUE)
  {
    mcs_manager_set_int(pManager, "Icon/Show/OtherWS/Minimized", CHANNEL, 1);
    mcs_manager_set_int(pManager, "Icon/Show/OtherWS/Maximized", CHANNEL, 1);
  }
  else if(bAllWS==TRUE && bAllApps!=TRUE)
  {
    mcs_manager_set_int(pManager, "Icon/Show/OtherWS/Minimized", CHANNEL, 1);
    mcs_manager_set_int(pManager, "Icon/Show/OtherWS/Maximized", CHANNEL, 0);
  }
  else
  {
    mcs_manager_set_int(pManager, "Icon/Show/OtherWS/Minimized", CHANNEL, 0);
    mcs_manager_set_int(pManager, "Icon/Show/OtherWS/Maximized", CHANNEL, 0);
  };  

  mcs_manager_notify(pManager, CHANNEL);
  ls_iconboxconf_write(plsibwcw, NULL);
  
  return;
};

static void cb_lsibc_color(GtkWidget *pWidget, gpointer pUserData)
{ 
  LSIconBoxConf 	*plsibwcw;
  McsManager		*pManager;
  LSIconBoxConfPrivate	*pp;

  g_return_if_fail(pUserData!=NULL);
  plsibwcw		= pUserData;
  pp			= plsibwcw->priv;
  pManager		= plsibwcw->priv->pmcsManager;
  g_return_if_fail(pManager!=NULL);

  if(
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_2))
  ) {
    mcs_manager_set_int(pManager, "Icon/Color/Use", CHANNEL, 1);
  }
  else
  {
    mcs_manager_set_int(pManager, "Icon/Color/Use", CHANNEL, 0);
  };
  
  mcs_manager_notify(pManager, CHANNEL);
  ls_iconboxconf_write(plsibwcw, NULL);

  return;
};

static void cb_lsibc_hide(GtkWidget *pWidget, gpointer pUserData)
{ 
  LSIconBoxConf 	*plsibwcw;
  McsManager		*pManager;
  LSIconBoxConfPrivate	*pp;

  g_return_if_fail(pUserData!=NULL);
  plsibwcw		= pUserData;
  pp			= plsibwcw->priv;
  pManager		= plsibwcw->priv->pmcsManager;
  g_return_if_fail(pManager!=NULL);

  if(
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(pp->widgets.frame_2_btn_3))
  ) {
    mcs_manager_set_int(pManager, "Window/HideOnEmpty", CHANNEL, 1);
  }
  else
  {
    mcs_manager_set_int(pManager, "Window/HideOnEmpty", CHANNEL, 0);
  };
  
  mcs_manager_notify(pManager, CHANNEL);
  ls_iconboxconf_write(plsibwcw, NULL);

  return;
};

