/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * gui_pathselectiondialog.c - creation and destruction of the path selection dialog
 *
 * this dialog used by the preferences dialog. You can select a path where your logs
 * are saved. If OK is clicked, the entry in the preferences dialog is updated. The
 * actual path is set when OK is clicked in the preferences dialog.
 */

#include <gtk/gtk.h>

#include "gui_pathselectiondialog.h"
#include "support.h"

extern GtkWidget *preferencesdialog;

static void
getpath (GtkWidget *widget, gpointer user_data)
{
	GtkWidget *pathselection = GTK_WIDGET (user_data);
	G_CONST_RETURN gchar *selpath;
	GtkWidget *pathentry;

	selpath =	gtk_file_selection_get_filename (GTK_FILE_SELECTION(pathselection));
	pathentry = lookup_widget (preferencesdialog, "pathentry");
	gtk_entry_set_text (GTK_ENTRY (pathentry), selpath);
	gtk_widget_set_sensitive (preferencesdialog, 1);
}

void
on_pathbutton_clicked (GtkButton * button, gpointer user_data)
{
	GtkWidget *pathselection, *pathselection_ok_button, *pathselection_cancel_button;
	GdkPixbuf *pathselection_icon_pixbuf;

	pathselection = gtk_file_selection_new (_("xlog - select a directory"));
	gtk_container_set_border_width (GTK_CONTAINER (pathselection), 10);
	gtk_window_set_position (GTK_WINDOW (pathselection), GTK_WIN_POS_MOUSE);
	pathselection_icon_pixbuf = create_pixbuf ("xlog.png");
	if (pathselection_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (pathselection), pathselection_icon_pixbuf);
			g_object_unref (pathselection_icon_pixbuf);
		}

	pathselection_ok_button = GTK_FILE_SELECTION (pathselection)->ok_button;
	gtk_widget_show (pathselection_ok_button);
	GTK_WIDGET_SET_FLAGS (pathselection_ok_button, GTK_CAN_DEFAULT);

	pathselection_cancel_button = GTK_FILE_SELECTION (pathselection)->cancel_button;
	gtk_widget_show (pathselection_cancel_button);
	GTK_WIDGET_SET_FLAGS (pathselection_cancel_button, GTK_CAN_DEFAULT);

	gtk_editable_set_editable (GTK_EDITABLE(GTK_FILE_SELECTION (pathselection)-> selection_entry), FALSE);
	gtk_widget_set_sensitive (GTK_FILE_SELECTION (pathselection)->file_list, FALSE);

	g_signal_connect (GTK_FILE_SELECTION (pathselection)->ok_button, "clicked",
		G_CALLBACK (getpath), pathselection);
	g_signal_connect_swapped (GTK_FILE_SELECTION (pathselection)->ok_button, "clicked",
		G_CALLBACK (gtk_widget_destroy), pathselection);
	g_signal_connect_swapped (GTK_FILE_SELECTION (pathselection)->cancel_button, "clicked",
		G_CALLBACK (gtk_widget_destroy), pathselection);
	gtk_widget_set_sensitive (preferencesdialog, 0);
	gtk_widget_show (pathselection);
}
