#include "common.h"
#include "gtkfunc.h"
#include "listwindow.h"
#include "sendcontact.h"
#include "util.h"
#include "v7send.h"
#include "v7snac13.h"
#include "groups.h"
#include "gnomeicu.h"

#include <gtk/gtk.h>
#include <string.h>

static void move_contacts_to_list( GtkWidget *widget, gpointer data );
static void send_contact_list( GtkWidget *widget, gpointer data );

void contact_list_window( CONTACT_PTR contact )
{
	GtkWidget *dlg;
        gchar *msg;
	
	g_assert(contact != NULL);

        msg = g_strdup_printf( _("Drag the users you wish to send\n"
				 "to %s to this window, and then click the\n"
				 "\"Send\" button below."), contact->nick ?
				 contact->nick : contact->uin);
	dlg = list_window_new (
		_("Send Contact List"),
		msg, _("_Send"), GTK_STOCK_JUMP_TO,
		G_CALLBACK (send_contact_list),
		NULL
	);
	g_free(msg);

	g_object_set_data(G_OBJECT(g_object_get_data(G_OBJECT(dlg), "button")),
			  "uin", contact->uin);
	gtk_widget_show_all( dlg );
}

void received_contact_list_window( CONTACT_PTR contact, GSList *contacts )
{
	GtkWidget *dlg;
	GtkCList *clist;
	char *caption;
	char *buf[2];
	
	g_assert(contact != NULL);

        caption = g_strdup_printf( _("The following contact list was sent by %s.\n"
				   "Please remove the users you don't want to add\n "
				   "and then click the \"Add\" button below."),
				   contact->nick ?  contact->nick : contact->uin);
	dlg = list_window_new (
		_("Received Contact List"),
		caption, GTK_STOCK_ADD, NULL,
		G_CALLBACK (move_contacts_to_list),
		NULL
	);
	g_free (caption);

	clist = g_object_get_data (G_OBJECT (dlg), "clist");

	while (contacts != NULL) {
		buf[0] = ((ContactPair *)contacts->data)->textuin;
		buf[1] = ((ContactPair *)contacts->data)->nick;
		gtk_clist_append( clist, buf );
		g_free (contacts->data);
		contacts = g_slist_remove(contacts, contacts->data);
	}

	gtk_widget_show_all( dlg );
}

void move_contacts_to_list( GtkWidget *widget, gpointer data )
{
  GtkWidget *dialog;
  GtkWidget *dropdown;
  GtkWidget *label;
  GtkWidget *g_omenu_menu;
  GtkWidget *clist;
  guint counter, general=0;
  GSList *ginfo;
  GtkWidget *menuitem;
  GList *menuiteml;
  gchar *nick;
  UIN_T uin;
  int cx;
  int gid = 0;


  dialog = gtk_dialog_new_with_buttons(_("Add to group"), NULL, 0,
			  GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
			  GTK_STOCK_OK, GTK_RESPONSE_OK,
			  NULL);
	
  label = gtk_label_new (_("These contacts will be added to group:"));

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
		     label);

	
  g_omenu_menu = gtk_menu_new();
  
  counter = 0;
  for (ginfo = Groups; ginfo != NULL; ginfo = ginfo->next, counter++) {
    GroupInfo *group = (GroupInfo *) ginfo->data;
    menuitem = gtk_menu_item_new_with_label(group->name);
    g_object_set_data(G_OBJECT(menuitem), "gid",
		      GUINT_TO_POINTER((guint)group->gid));
    gtk_menu_shell_append(GTK_MENU_SHELL(g_omenu_menu), menuitem);
    if (!strcmp(group->name, "General"))
      general = counter;
  }

  dropdown = gtk_option_menu_new();
  gtk_option_menu_set_menu( GTK_OPTION_MENU(dropdown), g_omenu_menu);

  if (general)
    gtk_option_menu_set_history( GTK_OPTION_MENU(dropdown), general);

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox),
		     dropdown);

  gtk_widget_show_all(GTK_DIALOG(dialog)->vbox);

  if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_OK) {

    menuiteml = g_list_nth(GTK_MENU_SHELL(g_omenu_menu)->children,
			  gtk_option_menu_get_history (GTK_OPTION_MENU(dropdown)));
    gid = GPOINTER_TO_UINT (g_object_get_data(G_OBJECT(menuiteml->data),"gid"));
  
    clist = g_object_get_data(g_object_get_data(G_OBJECT(widget), 
						"dlg"),
			      "clist");

    for( cx = 0; cx < GTK_CLIST(clist)->rows; cx ++ )
      {
	gtk_clist_get_text( GTK_CLIST(clist), cx, 0, &nick );
	uin = g_strdup( nick );
	gtk_clist_get_text( GTK_CLIST(clist), cx, 1, &nick );
	v7_try_add_uin (mainconnection, uin, nick, gid, FALSE);
	g_free (uin);
      }
  }
  gtk_widget_destroy(GTK_WIDGET(dialog));

}


void send_contact_list( GtkWidget *widget, gpointer data )
{

  GtkCList *clist = GTK_CLIST( data );
  GList *contacts = NULL;
  UIN_T uin;
  ContactPair *cpair;
  int i;
  gchar *nick;

#ifdef TRACE_FUNCTION
  g_print( "send_contact_list\n" );
#endif

  if (!is_connected(GTK_WINDOW(g_object_get_data (G_OBJECT (widget), "dlg")), _("You can not send contacts while being disconnected.")))
    return;
        
  uin = g_object_get_data (G_OBJECT (widget ), "uin" );

  if (clist->rows == 0)
    return;
  
  for( i = 0; i < clist->rows; i ++ ) {
    cpair = g_new0(ContactPair, 1);
    gtk_clist_get_text( clist, i, 0, &nick );
    cpair->textuin = g_strdup(nick);
    gtk_clist_get_text( clist, i, 1, &nick );
    cpair->nick = g_strdup(nick);
    contacts = g_list_append(contacts, cpair);
  }
        
  v7_sendcontacts(mainconnection, uin, contacts);

  while (contacts != NULL) {
    g_free(contacts->data);
    contacts = g_list_remove(contacts, contacts->data);
  }
  g_list_free(contacts);

 }
